/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.networking;

import dev.kir.sync.Sync;
import dev.kir.sync.api.networking.ClientPlayerPacket;
import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateUpdateType;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

public class ShellStateUpdatePacket
implements ClientPlayerPacket {
    private ShellStateUpdateType type;
    private ShellState shellState;
    private UUID uuid;
    private float progress;
    private DyeColor color;
    private BlockPos pos;

    public ShellStateUpdatePacket(ShellStateUpdateType type, ShellState shellState) {
        this.type = type;
        this.shellState = shellState;
    }

    @Override
    public ResourceLocation getId() {
        return Sync.locate("packet.shell.state.update");
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        if (this.shellState == null && this.type != ShellStateUpdateType.NONE) {
            throw new IllegalStateException();
        }
        buffer.m_130068_((Enum)this.type);
        switch (this.type) {
            case ADD: {
                buffer.m_130079_(this.shellState.writeNbt(new CompoundTag()));
                break;
            }
            case REMOVE: {
                buffer.m_130077_(this.shellState.getUuid());
                break;
            }
            case UPDATE: {
                buffer.m_130077_(this.shellState.getUuid());
                buffer.m_130130_((int)(this.shellState.getProgress() * 100.0f));
                buffer.m_130130_(this.shellState.getColor() == null ? 127 : this.shellState.getColor().m_41060_());
                buffer.m_130064_(this.shellState.getPos());
                break;
            }
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.type = (ShellStateUpdateType)buffer.m_130066_(ShellStateUpdateType.class);
        switch (this.type) {
            case ADD: {
                this.shellState = ShellState.fromNbt(buffer.m_130260_());
                break;
            }
            case REMOVE: {
                this.uuid = buffer.m_130259_();
                break;
            }
            case UPDATE: {
                this.uuid = buffer.m_130259_();
                this.progress = Mth.m_14036_((float)((float)buffer.m_130242_() / 100.0f), (float)0.0f, (float)1.0f);
                int colorId = buffer.m_130242_();
                this.color = colorId < 0 || colorId > 15 ? null : DyeColor.m_41053_((int)colorId);
                this.pos = buffer.m_130135_();
                break;
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void execute(Minecraft client, LocalPlayer player, ClientPacketListener handler, PacketSender responseSender) {
        Shell shell = (Shell)player;
        if (shell == null) {
            return;
        }
        switch (this.type) {
            case ADD: {
                shell.add(this.shellState);
                break;
            }
            case REMOVE: {
                ShellState state = shell.getShellStateByUuid(this.uuid);
                if (state == null) break;
                shell.remove(state);
                break;
            }
            case UPDATE: {
                ShellState state = shell.getShellStateByUuid(this.uuid);
                if (state == null) break;
                state.setProgress(this.progress);
                state.setColor(this.color);
                state.setPos(this.pos);
                break;
            }
        }
    }
}

