/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.networking;

import dev.kir.sync.Sync;
import dev.kir.sync.api.networking.ClientPlayerPacket;
import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ShellUpdatePacket
implements ClientPlayerPacket {
    private ResourceLocation worldId;
    private boolean isArtificial;
    private Collection<ShellState> states;

    public ShellUpdatePacket(ResourceLocation worldId, boolean isArtificial, Collection<ShellState> states) {
        this.worldId = worldId;
        this.isArtificial = isArtificial;
        this.states = states == null ? List.of() : states;
    }

    @Override
    public ResourceLocation getId() {
        return Sync.locate("packet.shell.update");
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.worldId);
        buffer.writeBoolean(this.isArtificial);
        buffer.m_130130_(this.states.size());
        this.states.forEach(x -> buffer.m_130079_(x.writeNbt(new CompoundTag())));
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.worldId = buffer.m_130281_();
        this.isArtificial = buffer.readBoolean();
        this.states = buffer.m_236845_(subBuffer -> ShellState.fromNbt(subBuffer.m_130260_()));
    }

    @Override
    public ResourceLocation getTargetWorldId() {
        return this.worldId;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void execute(Minecraft client, LocalPlayer player, ClientPacketListener handler, PacketSender responseSender) {
        Shell shell = (Shell)player;
        shell.changeArtificialStatus(this.isArtificial);
        shell.setAvailableShellStates(this.states.stream());
    }
}

