/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.networking;

import dev.kir.sync.Sync;
import dev.kir.sync.api.networking.ServerPlayerPacket;
import dev.kir.sync.api.networking.SynchronizationResponsePacket;
import dev.kir.sync.api.shell.ServerShell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.util.BlockPosUtil;
import dev.kir.sync.util.WorldUtil;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class SynchronizationRequestPacket
implements ServerPlayerPacket {
    private UUID shellUuid;

    public SynchronizationRequestPacket(ShellState shell) {
        this.shellUuid = shell == null ? null : shell.getUuid();
    }

    public SynchronizationRequestPacket(UUID shellUuid) {
        this.shellUuid = shellUuid;
    }

    @Override
    public ResourceLocation getId() {
        return Sync.locate("packet.shell.synchronization.request");
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        if (this.shellUuid == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130077_(this.shellUuid);
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.shellUuid = buffer.readBoolean() ? buffer.m_130259_() : null;
    }

    @Override
    public void execute(MinecraftServer server, ServerPlayer player, ServerGamePacketListenerImpl handler, PacketSender responseSender) {
        ServerShell shell = (ServerShell)player;
        ShellState state = shell.getShellStateByUuid(this.shellUuid);
        BlockPos currentPos = player.m_20183_();
        Level currentWorld = player.m_9236_();
        ResourceLocation currentWorldId = WorldUtil.getId(currentWorld);
        Direction currentFacing = BlockPosUtil.getHorizontalFacing(currentPos, (BlockGetter)currentWorld).orElse(player.m_6350_().m_122424_());
        shell.sync(state).ifLeft(storedState -> {
            Objects.requireNonNull(state);
            ResourceLocation targetWorldId = state.getWorld();
            BlockPos targetPos = state.getPos();
            Direction targetFacing = player.m_6350_().m_122424_();
            new SynchronizationResponsePacket(currentWorldId, currentPos, currentFacing, targetWorldId, targetPos, targetFacing, (ShellState)storedState).send(responseSender);
        }).ifRight(failureReason -> {
            player.m_5661_(failureReason.toText(), false);
            new SynchronizationResponsePacket(currentWorldId, currentPos, currentFacing, currentWorldId, currentPos, currentFacing, null).send(responseSender);
        });
    }
}

