/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.networking;

import dev.kir.sync.Sync;
import dev.kir.sync.api.networking.ClientPlayerPacket;
import dev.kir.sync.api.shell.ClientShell;
import dev.kir.sync.api.shell.ShellState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SynchronizationResponsePacket
implements ClientPlayerPacket {
    private ResourceLocation startWorld;
    private BlockPos startPos;
    private Direction startFacing;
    private ResourceLocation targetWorld;
    private BlockPos targetPos;
    private Direction targetFacing;
    private ShellState storedState;

    public SynchronizationResponsePacket(ResourceLocation startWorld, BlockPos startPos, Direction startFacing, ResourceLocation targetWorld, BlockPos targetPos, Direction targetFacing, @Nullable ShellState storedState) {
        this.startWorld = startWorld;
        this.startPos = startPos;
        this.startFacing = startFacing;
        this.targetWorld = targetWorld;
        this.targetPos = targetPos;
        this.targetFacing = targetFacing;
        this.storedState = storedState;
    }

    @Override
    public ResourceLocation getId() {
        return Sync.locate("packet.shell.synchronization.response");
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.startWorld);
        buffer.m_130064_(this.startPos);
        buffer.m_130130_(this.startFacing.m_122411_());
        buffer.m_130085_(this.targetWorld);
        buffer.m_130064_(this.targetPos);
        buffer.m_130130_(this.targetFacing.m_122411_());
        if (this.storedState == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130079_(this.storedState.writeNbt(new CompoundTag()));
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.startWorld = buffer.m_130281_();
        this.startPos = buffer.m_130135_();
        this.startFacing = Direction.m_122376_((int)buffer.m_130242_());
        this.targetWorld = buffer.m_130281_();
        this.targetPos = buffer.m_130135_();
        this.targetFacing = Direction.m_122376_((int)buffer.m_130242_());
        this.storedState = buffer.readBoolean() ? ShellState.fromNbt(buffer.m_130260_()) : null;
    }

    @Override
    public ResourceLocation getTargetWorldId() {
        return this.targetWorld;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void execute(Minecraft client, LocalPlayer player, ClientPacketListener handler, PacketSender responseSender) {
        ((ClientShell)player).endSync(this.startWorld, this.startPos, this.startFacing, this.targetWorld, this.targetPos, this.targetFacing, this.storedState);
    }
}

