/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.shell;

import dev.kir.sync.api.shell.ShellState;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;

public enum ShellPriority implements StringRepresentable
{
    WHITE(DyeColor.WHITE),
    ORANGE(DyeColor.ORANGE),
    MAGENTA(DyeColor.MAGENTA),
    LIGHT_BLUE(DyeColor.LIGHT_BLUE),
    YELLOW(DyeColor.YELLOW),
    LIME(DyeColor.LIME),
    PINK(DyeColor.PINK),
    GRAY(DyeColor.GRAY),
    LIGHT_GRAY(DyeColor.LIGHT_GRAY),
    CYAN(DyeColor.CYAN),
    PURPLE(DyeColor.PURPLE),
    BLUE(DyeColor.BLUE),
    BROWN(DyeColor.BROWN),
    GREEN(DyeColor.GREEN),
    RED(DyeColor.RED),
    BLACK(DyeColor.BLACK),
    NEAREST(16, "nearest", null, true),
    NATURAL(17, "natural", true, null);

    private final int id;
    private final String name;
    private final Boolean nearest;
    private final Boolean natural;

    private ShellPriority(DyeColor color) {
        this(color.m_41060_(), color.m_41065_(), null, null);
    }

    private ShellPriority(int id, String name, Boolean natural, Boolean nearest) {
        this.id = id;
        this.name = name;
        this.natural = natural;
        this.nearest = nearest;
    }

    public String m_7912_() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static Comparator<ShellState> asComparator(ShellPriority priority) {
        return ShellPriority.asComparator(null, null, priority);
    }

    public static Comparator<ShellState> asComparator(ShellPriority ... priorities) {
        return ShellPriority.asComparator(null, null, priorities);
    }

    public static Comparator<ShellState> asComparator(Collection<ShellPriority> priorities) {
        return ShellPriority.asComparator(null, null, priorities);
    }

    public static Comparator<ShellState> asComparator(Stream<ShellPriority> priorities) {
        return ShellPriority.asComparator(null, null, priorities);
    }

    public static Comparator<ShellState> asComparator(ResourceLocation world, BlockPos pos, ShellPriority priority) {
        return (a, b) -> {
            DyeColor color;
            DyeColor dyeColor = color = priority.id >= 0 && priority.id <= 15 ? DyeColor.m_41053_((int)priority.id) : null;
            if (color != null && a.getColor() != b.getColor() && (a.getColor() == color || b.getColor() == color)) {
                return a.getColor() == color ? -1 : 1;
            }
            if (priority.natural != null && a.isArtificial() != b.isArtificial()) {
                return (a.isArtificial() ? 1 : -1) * (priority.natural != false ? 1 : -1);
            }
            if (priority.nearest != null && world != null && pos != null) {
                boolean aWorld = a.getWorld().equals((Object)world);
                boolean bWorld = b.getWorld().equals((Object)world);
                if (aWorld && bWorld) {
                    return Double.compare(a.getPos().m_123331_((Vec3i)pos), b.getPos().m_123331_((Vec3i)pos));
                }
                return Boolean.compare(bWorld, aWorld);
            }
            return 0;
        };
    }

    public static Comparator<ShellState> asComparator(ResourceLocation world, BlockPos pos, ShellPriority ... priorities) {
        return ShellPriority.asComparator(world, pos, Arrays.stream(priorities));
    }

    public static Comparator<ShellState> asComparator(ResourceLocation world, BlockPos pos, Collection<ShellPriority> priorities) {
        return ShellPriority.asComparator(world, pos, priorities.stream());
    }

    public static Comparator<ShellState> asComparator(ResourceLocation world, BlockPos pos, Stream<ShellPriority> priorities) {
        return priorities.reduce((__, ___) -> 0, (acc, x) -> acc.thenComparing(ShellPriority.asComparator(world, pos, x)), Comparator::thenComparing);
    }
}

