/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.shell;

import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellStateComponent;
import dev.kir.sync.entity.ShellEntity;
import dev.kir.sync.item.SimpleInventory;
import dev.kir.sync.util.WorldUtil;
import dev.kir.sync.util.nbt.NbtSerializer;
import dev.kir.sync.util.nbt.NbtSerializerFactory;
import dev.kir.sync.util.nbt.NbtSerializerFactoryBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShellState {
    public static final float PROGRESS_START = 0.0f;
    public static final float PROGRESS_DONE = 1.0f;
    public static final float PROGRESS_PRINTING = 0.75f;
    public static final float PROGRESS_PAINTING = 0.25f;
    private static final NbtSerializerFactory<ShellState> NBT_SERIALIZER_FACTORY = new NbtSerializerFactoryBuilder<ShellState>().add(UUID.class, "uuid", x -> x.uuid, (x, uuid) -> {
        x.uuid = uuid;
    }).add(Integer.class, "color", x -> x.color == null ? -1 : x.color.m_41060_(), (x, color) -> {
        x.color = color == -1 ? null : DyeColor.m_41053_((int)color);
    }).add(Float.class, "progress", x -> Float.valueOf(x.progress), (x, progress) -> {
        x.progress = progress.floatValue();
    }).add(Boolean.class, "isArtificial", x -> x.isArtificial, (x, isArtificial) -> {
        x.isArtificial = isArtificial;
    }).add(UUID.class, "ownerUuid", x -> x.ownerUuid, (x, ownerUuid) -> {
        x.ownerUuid = ownerUuid;
    }).add(String.class, "ownerName", x -> x.ownerName, (x, ownerName) -> {
        x.ownerName = ownerName;
    }).add(Float.class, "health", x -> Float.valueOf(x.health), (x, health) -> {
        x.health = health.floatValue();
    }).add(Integer.class, "gameMode", x -> x.gameMode, (x, gameMode) -> {
        x.gameMode = gameMode;
    }).add(ListTag.class, "inventory", x -> x.inventory.writeNbt(new ListTag()), (x, inventory) -> {
        x.inventory = new SimpleInventory();
        x.inventory.readNbt((ListTag)inventory);
    }).add(CompoundTag.class, "components", x -> x.component.writeNbt(new CompoundTag()), (x, component) -> {
        x.component = ShellStateComponent.empty();
        if (component != null) {
            x.component.readNbt((CompoundTag)component);
        }
    }).add(Integer.class, "foodLevel", x -> x.foodLevel, (x, foodLevel) -> {
        x.foodLevel = foodLevel;
    }).add(Float.class, "saturationLevel", x -> Float.valueOf(x.saturationLevel), (x, saturationLevel) -> {
        x.saturationLevel = saturationLevel.floatValue();
    }).add(Float.class, "exhaustion", x -> Float.valueOf(x.exhaustion), (x, exhaustion) -> {
        x.exhaustion = exhaustion.floatValue();
    }).add(Integer.class, "experienceLevel", x -> x.experienceLevel, (x, experienceLevel) -> {
        x.experienceLevel = experienceLevel;
    }).add(Float.class, "experienceProgress", x -> Float.valueOf(x.experienceProgress), (x, experienceProgress) -> {
        x.experienceProgress = experienceProgress.floatValue();
    }).add(Integer.class, "totalExperience", x -> x.totalExperience, (x, totalExperience) -> {
        x.totalExperience = totalExperience;
    }).add(ResourceLocation.class, "world", x -> x.world, (x, world) -> {
        x.world = world;
    }).add(BlockPos.class, "pos", x -> x.pos, (x, pos) -> {
        x.pos = pos;
    }).build();
    private UUID uuid;
    private float progress;
    private DyeColor color;
    private boolean isArtificial;
    private UUID ownerUuid;
    private String ownerName;
    private float health;
    private int gameMode;
    private SimpleInventory inventory;
    private ShellStateComponent component;
    private int foodLevel;
    private float saturationLevel;
    private float exhaustion;
    private int experienceLevel;
    private float experienceProgress;
    private int totalExperience;
    private ResourceLocation world;
    private BlockPos pos;
    private final NbtSerializer<ShellState> serializer = NBT_SERIALIZER_FACTORY.create(this);
    @Environment(value=EnvType.CLIENT)
    private ShellEntity entityInstance;

    public UUID getUuid() {
        return this.uuid;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor color) {
        this.color = color;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
    }

    public boolean isArtificial() {
        return this.isArtificial;
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public float getHealth() {
        return this.health;
    }

    public int getGameMode() {
        return this.gameMode;
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public ShellStateComponent getComponent() {
        return this.component;
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public float getSaturationLevel() {
        return this.saturationLevel;
    }

    public float getExhaustion() {
        return this.exhaustion;
    }

    public int getExperienceLevel() {
        return this.experienceLevel;
    }

    public float getExperienceProgress() {
        return this.experienceProgress;
    }

    public int getTotalExperience() {
        return this.totalExperience;
    }

    public ResourceLocation getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    private ShellState() {
    }

    public static ShellState empty(ServerPlayer player, BlockPos pos) {
        return ShellState.empty(player, pos, null);
    }

    public static ShellState empty(ServerPlayer player, BlockPos pos, DyeColor color) {
        return ShellState.create(player, pos, color, 0.0f, true, false);
    }

    public static ShellState of(ServerPlayer player, BlockPos pos) {
        return ShellState.of(player, pos, null);
    }

    public static ShellState of(ServerPlayer player, BlockPos pos, DyeColor color) {
        return ShellState.create(player, pos, color, 1.0f, ((Shell)player).isArtificial(), true);
    }

    public static ShellState fromNbt(CompoundTag nbt) {
        ShellState state = new ShellState();
        state.readNbt(nbt);
        return state;
    }

    private static ShellState create(ServerPlayer player, BlockPos pos, DyeColor color, float progress, boolean isArtificial, boolean copyPlayerState) {
        ShellState shell = new ShellState();
        shell.uuid = UUID.randomUUID();
        shell.progress = progress;
        shell.color = color;
        shell.isArtificial = isArtificial;
        shell.ownerUuid = player.m_20148_();
        shell.ownerName = player.m_7755_().getString();
        shell.gameMode = player.f_8941_.m_9290_().m_46392_();
        shell.inventory = new SimpleInventory();
        shell.component = ShellStateComponent.empty();
        if (copyPlayerState) {
            shell.health = player.m_21223_();
            shell.inventory.clone((Container)player.m_150109_());
            shell.component.clone(ShellStateComponent.of(player));
            shell.foodLevel = player.m_36324_().m_38702_();
            shell.saturationLevel = player.m_36324_().m_38722_();
            shell.exhaustion = player.m_36324_().m_150380_();
            shell.experienceLevel = player.f_36078_;
            shell.experienceProgress = player.f_36080_;
            shell.totalExperience = player.f_36079_;
        } else {
            shell.health = player.m_21233_();
            shell.foodLevel = 20;
            shell.saturationLevel = 5.0f;
        }
        shell.world = WorldUtil.getId(player.m_9236_());
        shell.pos = pos;
        return shell;
    }

    public void dropInventory(ServerLevel world) {
        this.dropInventory(world, this.pos);
    }

    public void dropInventory(ServerLevel world, BlockPos pos) {
        Stream.of(this.inventory.main, this.inventory.armor, this.inventory.offHand, this.component.getItems()).flatMap(Collection::stream).forEach(x -> this.dropItemStack((Level)world, pos, (ItemStack)x));
    }

    public void dropXp(ServerLevel world) {
        this.dropXp(world, this.pos);
    }

    public void dropXp(ServerLevel world, BlockPos pos) {
        int xp = Math.min(this.experienceLevel * 7, 100) + this.component.getXp();
        Vec3 vecPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        ExperienceOrb.m_147082_((ServerLevel)world, (Vec3)vecPos, (int)xp);
    }

    public void drop(ServerLevel world) {
        this.drop(world, this.pos);
    }

    public void drop(ServerLevel world, BlockPos pos) {
        this.dropInventory(world, pos);
        this.dropXp(world, pos);
    }

    private void dropItemStack(Level world, BlockPos pos, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ItemEntity item = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
        item.m_32010_(40);
        if (world instanceof ServerLevel) {
            item.m_32052_(this.getOwnerUuid());
        }
        float h = world.f_46441_.m_188501_() * 0.5f;
        float v = world.f_46441_.m_188501_() * 2.0f * (float)Math.PI;
        item.m_20334_((double)(-Mth.m_14031_((float)v) * h), 0.2, (double)(Mth.m_14089_((float)v) * h));
        world.m_7967_((Entity)item);
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        return this.serializer.writeNbt(nbt);
    }

    public void readNbt(CompoundTag nbt) {
        this.serializer.readNbt(nbt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof ShellState)) return false;
        ShellState state = (ShellState)o;
        if (!Objects.equals(this.uuid, state.uuid)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    @Environment(value=EnvType.CLIENT)
    public ShellEntity asEntity() {
        if (this.entityInstance == null) {
            this.entityInstance = new ShellEntity(this);
        }
        return this.entityInstance;
    }
}

