/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.shell;

import dev.kir.sync.api.shell.ShellStateComponentFactoryRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ShellStateComponent {
    public abstract String getId();

    public Collection<ItemStack> getItems() {
        return List.of();
    }

    public int getXp() {
        return 0;
    }

    public abstract void clone(ShellStateComponent var1);

    @ApiStatus.NonExtendable
    public void readNbt(CompoundTag nbt) {
        this.readComponentNbt(nbt.m_128469_(this.getId()));
    }

    protected abstract void readComponentNbt(CompoundTag var1);

    @ApiStatus.NonExtendable
    public CompoundTag writeNbt(CompoundTag nbt) {
        CompoundTag componentNbt = this.writeComponentNbt(new CompoundTag());
        nbt.m_128365_(this.getId(), (Tag)componentNbt);
        return nbt;
    }

    protected abstract CompoundTag writeComponentNbt(CompoundTag var1);

    @Nullable
    public <T> T as(Class<T> type) {
        return (T)(type.isInstance(this) ? this : null);
    }

    public static ShellStateComponent empty() {
        Collection<ShellStateComponentFactoryRegistry.ShellStateComponentFactory> factories = ShellStateComponentFactoryRegistry.getInstance().getValues();
        ArrayList<ShellStateComponent> components = new ArrayList<ShellStateComponent>(factories.size());
        for (ShellStateComponentFactoryRegistry.ShellStateComponentFactory factory : factories) {
            components.add(factory.empty());
        }
        return ShellStateComponent.combine(components);
    }

    public static ShellStateComponent of(ServerPlayer player) {
        Collection<ShellStateComponentFactoryRegistry.ShellStateComponentFactory> factories = ShellStateComponentFactoryRegistry.getInstance().getValues();
        ArrayList<ShellStateComponent> components = new ArrayList<ShellStateComponent>(factories.size());
        for (ShellStateComponentFactoryRegistry.ShellStateComponentFactory factory : factories) {
            components.add(factory.of(player));
        }
        return ShellStateComponent.combine(components);
    }

    public static ShellStateComponent combine() {
        return EmptyShellStateComponent.INSTANCE;
    }

    public static ShellStateComponent combine(ShellStateComponent component) {
        return component;
    }

    public static ShellStateComponent combine(ShellStateComponent ... components) {
        return ShellStateComponent.combine(Arrays.asList(components));
    }

    public static ShellStateComponent combine(Collection<ShellStateComponent> components) {
        return switch (components.size()) {
            case 0 -> EmptyShellStateComponent.INSTANCE;
            case 1 -> components.iterator().next();
            default -> new CombinedShellStateComponent(components);
        };
    }

    private static class EmptyShellStateComponent
    extends ShellStateComponent {
        public static final ShellStateComponent INSTANCE = new EmptyShellStateComponent();

        private EmptyShellStateComponent() {
        }

        @Override
        public String getId() {
            return "sync:empty";
        }

        @Override
        public void clone(ShellStateComponent component) {
        }

        @Override
        public void readNbt(CompoundTag nbt) {
        }

        @Override
        public CompoundTag writeNbt(CompoundTag nbt) {
            return nbt;
        }

        @Override
        public <T> T as(Class<T> type) {
            return null;
        }

        @Override
        protected void readComponentNbt(CompoundTag nbt) {
        }

        @Override
        protected CompoundTag writeComponentNbt(CompoundTag nbt) {
            return nbt;
        }
    }

    private static class CombinedShellStateComponent
    extends ShellStateComponent {
        private final Collection<ShellStateComponent> components;

        public CombinedShellStateComponent(Collection<ShellStateComponent> components) {
            this.components = List.copyOf(components);
        }

        @Override
        public String getId() {
            return "sync:combined";
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ShellStateComponent component : this.components) {
                items.addAll(component.getItems());
            }
            return items;
        }

        @Override
        public int getXp() {
            int xp = 0;
            for (ShellStateComponent component : this.components) {
                xp += component.getXp();
            }
            return xp;
        }

        @Override
        public void clone(ShellStateComponent component) {
            for (ShellStateComponent innerComponent : this.components) {
                innerComponent.clone(component);
            }
        }

        @Override
        public <T> T as(Class<T> type) {
            for (ShellStateComponent component : this.components) {
                T result = component.as(type);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            for (ShellStateComponent component : this.components) {
                component.readNbt(nbt);
            }
        }

        @Override
        public CompoundTag writeNbt(CompoundTag nbt) {
            for (ShellStateComponent component : this.components) {
                component.writeNbt(nbt);
            }
            return nbt;
        }

        @Override
        protected void readComponentNbt(CompoundTag nbt) {
        }

        @Override
        protected CompoundTag writeComponentNbt(CompoundTag nbt) {
            return nbt;
        }
    }
}

