/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.shell;

import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateUpdateType;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.Nullable;

public interface ShellStateManager {
    public void setAvailableShellStates(UUID var1, Stream<ShellState> var2);

    public Stream<ShellState> getAvailableShellStates(UUID var1);

    @Nullable
    public ShellState getShellStateByUuid(UUID var1, UUID var2);

    public void add(ShellState var1);

    public void remove(ShellState var1);

    public void update(ShellState var1);

    default public void update(ShellStateUpdateType type, ShellState state) {
        switch (type) {
            case ADD: {
                this.add(state);
                break;
            }
            case UPDATE: {
                this.update(state);
                break;
            }
            case REMOVE: {
                this.remove(state);
                break;
            }
        }
    }

    default public boolean isValidShellOwnerUuid(UUID uuid) {
        return uuid != null;
    }

    default public boolean isValidShellState(ShellState state) {
        return state != null && state.getUuid() != null && state.getOwnerUuid() != null;
    }

    public Collection<Tuple<ShellStateUpdateType, ShellState>> peekPendingUpdates(UUID var1);

    public void clearPendingUpdates(UUID var1);

    default public Collection<Tuple<ShellStateUpdateType, ShellState>> popPendingUpdates(UUID owner) {
        Collection<Tuple<ShellStateUpdateType, ShellState>> updates = this.peekPendingUpdates(owner);
        this.clearPendingUpdates(owner);
        return updates;
    }
}

