/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block;

import dev.kir.sync.block.entity.AbstractShellContainerBlockEntity;
import dev.kir.sync.block.entity.TickableBlockEntity;
import dev.kir.sync.util.ItemUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractShellContainerBlock
extends BaseEntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<ComparatorOutputType> OUTPUT = EnumProperty.m_61587_((String)"output", ComparatorOutputType.class);
    private static final VoxelShape SOLID_SHAPE_TOP;
    private static final VoxelShape SOLID_SHAPE_BOTTOM;
    private static final VoxelShape NORTH_SHAPE_TOP;
    private static final VoxelShape NORTH_SHAPE_BOTTOM;
    private static final VoxelShape SOUTH_SHAPE_TOP;
    private static final VoxelShape SOUTH_SHAPE_BOTTOM;
    private static final VoxelShape EAST_SHAPE_TOP;
    private static final VoxelShape EAST_SHAPE_BOTTOM;
    private static final VoxelShape WEST_SHAPE_TOP;
    private static final VoxelShape WEST_SHAPE_BOTTOM;

    protected AbstractShellContainerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(OUTPUT, (Comparable)((Object)ComparatorOutputType.PROGRESS)));
    }

    public static void setOpen(BlockState state, Level world, BlockPos pos, boolean open) {
        if ((Boolean)state.m_61143_((Property)OPEN) != open) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            BlockPos secondPos = pos.m_121945_(AbstractShellContainerBlock.getDirectionTowardsAnotherPart(state));
            BlockState secondState = world.m_8055_(secondPos);
            if (secondState != null) {
                world.m_7731_(secondPos, (BlockState)secondState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            }
        }
    }

    public static boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public static boolean isBottom(BlockState state) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        return half == DoubleBlockHalf.LOWER;
    }

    public static DoubleBlockCombiner.BlockType getShellContainerHalf(BlockState state) {
        DoubleBlockHalf part = (DoubleBlockHalf)state.m_61143_(HALF);
        return part == DoubleBlockHalf.LOWER ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public static Direction getDirectionTowardsAnotherPart(BlockState state) {
        return AbstractShellContainerBlock.isBottom(state) ? Direction.UP : Direction.DOWN;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(HALF) != doubleBlockHalf ? (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)neighborState.m_61143_((Property)FACING))) : Blocks.f_50016_.m_49966_();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        if (Level.m_46741_((BlockPos)blockPos) && world.m_8055_(blockPos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(state, world, pos, entity);
        if (!world.f_46443_ && entity instanceof Player && AbstractShellContainerBlock.isBottom(state)) {
            AbstractShellContainerBlock.setOpen(state, world, pos, true);
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockState blockState;
        BlockPos bottomPos;
        boolean bottom = AbstractShellContainerBlock.isBottom(state);
        BlockPos blockPos = bottomPos = bottom ? pos : pos.m_7495_();
        if (!world.f_46443_ && player.m_7500_() && !bottom && (blockState = world.m_8055_(bottomPos)).m_60734_() == state.m_60734_() && blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            world.m_7731_(bottomPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, bottomPos, Block.m_49956_((BlockState)blockState));
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (AbstractShellContainerBlock.isBottom(state) && (blockEntity = world.m_7702_(pos)) instanceof AbstractShellContainerBlockEntity) {
                AbstractShellContainerBlockEntity shellContainer = (AbstractShellContainerBlockEntity)blockEntity;
                shellContainer.onBreak(world, pos);
            }
            world.m_46747_(pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (ItemUtil.isWrench(player.m_21120_(hand))) {
            if (!world.f_46443_) {
                world.m_7731_(pos, (BlockState)state.m_61122_(OUTPUT), 10);
                world.m_46717_(pos, state.m_60734_());
            }
            return InteractionResult.SUCCESS;
        }
        if (!AbstractShellContainerBlock.isBottom(state)) {
            pos = pos.m_7495_();
            state = world.m_8055_(pos);
        }
        if ((blockEntity = world.m_7702_(pos)) instanceof AbstractShellContainerBlockEntity) {
            AbstractShellContainerBlockEntity shellContainer = (AbstractShellContainerBlockEntity)blockEntity;
            return shellContainer.onUse(world, pos, player, hand);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        int n;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof AbstractShellContainerBlockEntity) {
            AbstractShellContainerBlockEntity shellContainer = (AbstractShellContainerBlockEntity)blockEntity;
            n = state.m_61143_(OUTPUT) == ComparatorOutputType.PROGRESS ? shellContainer.getProgressComparatorOutput() : shellContainer.getInventoryComparatorOutput();
        } else {
            n = 0;
        }
        return n;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Environment(value=EnvType.CLIENT)
    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING, OPEN, OUTPUT});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (!AbstractShellContainerBlock.isBottom(state)) {
            return null;
        }
        return world.f_46443_ ? TickableBlockEntity::clientTicker : TickableBlockEntity::serverTicker;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean isBottom = AbstractShellContainerBlock.isBottom(state);
        if (!AbstractShellContainerBlock.isOpen(state)) {
            return isBottom ? SOLID_SHAPE_BOTTOM : SOLID_SHAPE_TOP;
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return switch (direction) {
            case Direction.NORTH -> {
                if (isBottom) {
                    yield NORTH_SHAPE_BOTTOM;
                }
                yield NORTH_SHAPE_TOP;
            }
            case Direction.SOUTH -> {
                if (isBottom) {
                    yield SOUTH_SHAPE_BOTTOM;
                }
                yield SOUTH_SHAPE_TOP;
            }
            case Direction.EAST -> {
                if (isBottom) {
                    yield EAST_SHAPE_BOTTOM;
                }
                yield EAST_SHAPE_TOP;
            }
            case Direction.WEST -> {
                if (isBottom) {
                    yield WEST_SHAPE_BOTTOM;
                }
                yield WEST_SHAPE_TOP;
            }
            default -> throw new IllegalArgumentException();
        };
    }

    static {
        VoxelShape ROOF = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape FLOOR = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        VoxelShape NORTH_WALL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        VoxelShape SOUTH_WALL = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape EAST_WALL = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape WEST_WALL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        VoxelShape NORTH_SHAPE = Shapes.m_83124_((VoxelShape)NORTH_WALL, (VoxelShape[])new VoxelShape[]{EAST_WALL, WEST_WALL}).m_83296_();
        VoxelShape SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)SOUTH_WALL, (VoxelShape[])new VoxelShape[]{EAST_WALL, WEST_WALL}).m_83296_();
        VoxelShape EAST_SHAPE = Shapes.m_83124_((VoxelShape)NORTH_WALL, (VoxelShape[])new VoxelShape[]{SOUTH_WALL, EAST_WALL}).m_83296_();
        VoxelShape WEST_SHAPE = Shapes.m_83124_((VoxelShape)NORTH_WALL, (VoxelShape[])new VoxelShape[]{SOUTH_WALL, WEST_WALL}).m_83296_();
        SOLID_SHAPE_TOP = Shapes.m_83124_((VoxelShape)NORTH_WALL, (VoxelShape[])new VoxelShape[]{SOUTH_WALL, EAST_WALL, WEST_WALL, ROOF}).m_83296_();
        SOLID_SHAPE_BOTTOM = Shapes.m_83124_((VoxelShape)NORTH_WALL, (VoxelShape[])new VoxelShape[]{SOUTH_WALL, EAST_WALL, WEST_WALL, FLOOR}).m_83296_();
        NORTH_SHAPE_TOP = Shapes.m_83110_((VoxelShape)NORTH_SHAPE, (VoxelShape)ROOF).m_83296_();
        NORTH_SHAPE_BOTTOM = Shapes.m_83110_((VoxelShape)NORTH_SHAPE, (VoxelShape)FLOOR).m_83296_();
        SOUTH_SHAPE_TOP = Shapes.m_83110_((VoxelShape)SOUTH_SHAPE, (VoxelShape)ROOF).m_83296_();
        SOUTH_SHAPE_BOTTOM = Shapes.m_83110_((VoxelShape)SOUTH_SHAPE, (VoxelShape)FLOOR).m_83296_();
        EAST_SHAPE_TOP = Shapes.m_83110_((VoxelShape)EAST_SHAPE, (VoxelShape)ROOF).m_83296_();
        EAST_SHAPE_BOTTOM = Shapes.m_83110_((VoxelShape)EAST_SHAPE, (VoxelShape)FLOOR).m_83296_();
        WEST_SHAPE_TOP = Shapes.m_83110_((VoxelShape)WEST_SHAPE, (VoxelShape)ROOF).m_83296_();
        WEST_SHAPE_BOTTOM = Shapes.m_83110_((VoxelShape)WEST_SHAPE, (VoxelShape)FLOOR).m_83296_();
    }

    public static enum ComparatorOutputType implements StringRepresentable
    {
        PROGRESS,
        INVENTORY;


        public String m_7912_() {
            return this == PROGRESS ? "progress" : "inventory";
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

