/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block;

import dev.kir.sync.block.AbstractShellContainerBlock;
import dev.kir.sync.block.entity.ShellStorageBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ShellStorageBlock
extends AbstractShellContainerBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public ShellStorageBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isEnabled(BlockState state) {
        return (Boolean)state.m_61143_((Property)ENABLED);
    }

    public static boolean isPowered(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED);
    }

    public static void setPowered(BlockState state, Level world, BlockPos pos, boolean powered) {
        if ((Boolean)state.m_61143_((Property)POWERED) != powered) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 10);
            BlockPos secondPos = pos.m_121945_(ShellStorageBlock.getDirectionTowardsAnotherPart(state));
            BlockState secondState = world.m_8055_(secondPos);
            if (secondState != null) {
                world.m_7731_(secondPos, (BlockState)secondState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 10);
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShellStorageBlockEntity(pos, state);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        boolean shouldBeEnabled;
        boolean enabled;
        if (!world.f_46443_ && (enabled = ((Boolean)state.m_61143_((Property)ENABLED)).booleanValue()) != (shouldBeEnabled = ShellStorageBlock.shouldBeEnabled(state, world, pos))) {
            BlockPos secondPartPos = pos.m_121945_(ShellStorageBlock.getDirectionTowardsAnotherPart(state));
            if (enabled) {
                world.m_186460_(pos, (Block)this, 4);
                world.m_186460_(secondPartPos, (Block)this, 4);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)), 2);
                BlockState secondPartState = world.m_8055_(secondPartPos);
                if (secondPartState.m_60713_((Block)this)) {
                    world.m_7731_(secondPartPos, (BlockState)secondPartState.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)ENABLED)).booleanValue() && !ShellStorageBlock.shouldBeEnabled(state, (Level)world, pos)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    @Override
    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        super.m_7892_(state, world, pos, entity);
        if (world.f_46443_ && entity instanceof Player && ShellStorageBlock.isBottom(state) && (blockEntity = world.m_7702_(pos)) instanceof ShellStorageBlockEntity) {
            ((ShellStorageBlockEntity)blockEntity).onEntityCollisionClient(entity, state);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ENABLED});
        builder.m_61104_(new Property[]{POWERED});
    }

    private static boolean shouldBeEnabled(BlockState state, Level world, BlockPos pos) {
        return world.m_276867_(pos) || world.m_276867_(pos.m_121945_(ShellStorageBlock.getDirectionTowardsAnotherPart(state)));
    }
}

