/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block;

import dev.kir.sync.block.entity.SyncBlockEntities;
import dev.kir.sync.block.entity.TickableBlockEntity;
import dev.kir.sync.block.entity.TreadmillBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TreadmillBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"treadmill_part", Part.class);
    private static final VoxelShape NORTH_SHAPE_BACK;
    private static final VoxelShape NORTH_SHAPE_FRONT;
    private static final VoxelShape SOUTH_SHAPE_BACK;
    private static final VoxelShape SOUTH_SHAPE_FRONT;
    private static final VoxelShape EAST_SHAPE_BACK;
    private static final VoxelShape EAST_SHAPE_FRONT;
    private static final VoxelShape WEST_SHAPE_BACK;
    private static final VoxelShape WEST_SHAPE_FRONT;

    public TreadmillBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)Part.BACK)));
    }

    public static boolean isBack(BlockState state) {
        Part part = (Part)((Object)state.m_61143_(PART));
        return part == Part.BACK;
    }

    public static DoubleBlockCombiner.BlockType getTreadmillPart(BlockState state) {
        Part part = (Part)((Object)state.m_61143_(PART));
        return part == Part.BACK ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TreadmillBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Environment(value=EnvType.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        TreadmillBlockEntity back;
        TreadmillBlockEntity firstTreadmill;
        BlockEntity second;
        Part part;
        block5: {
            block4: {
                part = (Part)((Object)state.m_61143_(PART));
                Direction facing = (Direction)state.m_61143_((Property)f_54117_);
                BlockEntity first = world.m_7702_(pos);
                second = world.m_7702_(pos.m_121945_(TreadmillBlock.getDirectionTowardsOtherPart(part, facing)));
                if (!(first instanceof TreadmillBlockEntity)) break block4;
                firstTreadmill = (TreadmillBlockEntity)first;
                if (second instanceof TreadmillBlockEntity) break block5;
            }
            return;
        }
        TreadmillBlockEntity secondTreadmill = (TreadmillBlockEntity)second;
        TreadmillBlockEntity front = part == Part.BACK ? secondTreadmill : firstTreadmill;
        TreadmillBlockEntity treadmillBlockEntity = back = part == Part.BACK ? firstTreadmill : secondTreadmill;
        if (back.isOverheated()) {
            double x = (double)front.m_58899_().m_123341_() + random.m_188500_();
            double y = (double)front.m_58899_().m_123342_() + 0.4;
            double z = (double)front.m_58899_().m_123343_() + random.m_188500_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 0.0, 0.1, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == TreadmillBlock.getDirectionTowardsOtherPart((Part)((Object)state.m_61143_(PART)), (Direction)state.m_61143_((Property)f_54117_))) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(PART) != state.m_61143_(PART) ? state : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_();
        BlockPos blockPos = ctx.m_8083_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        return ctx.m_43725_().m_8055_(blockPos2).m_60629_(ctx) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_) {
            BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            world.m_7731_(blockPos, (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.FRONT)), 3);
            world.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        Part part;
        if (!world.f_46443_ && player.m_7500_() && (part = (Part)((Object)state.m_61143_(PART))) == Part.FRONT && (blockState = world.m_8055_(blockPos = pos.m_121945_(TreadmillBlock.getDirectionTowardsOtherPart(part, (Direction)state.m_61143_((Property)f_54117_))))).m_60734_() == this && blockState.m_61143_(PART) == Part.BACK) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        boolean isBack = TreadmillBlock.isBack(state);
        return switch (direction) {
            case Direction.NORTH -> {
                if (isBack) {
                    yield NORTH_SHAPE_BACK;
                }
                yield NORTH_SHAPE_FRONT;
            }
            case Direction.SOUTH -> {
                if (isBack) {
                    yield SOUTH_SHAPE_BACK;
                }
                yield SOUTH_SHAPE_FRONT;
            }
            case Direction.EAST -> {
                if (isBack) {
                    yield EAST_SHAPE_BACK;
                }
                yield EAST_SHAPE_FRONT;
            }
            case Direction.WEST -> {
                if (isBack) {
                    yield WEST_SHAPE_BACK;
                }
                yield WEST_SHAPE_FRONT;
            }
            default -> NORTH_SHAPE_FRONT;
        };
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TreadmillBlockEntity) {
            TreadmillBlockEntity treadmillBlockEntity = (TreadmillBlockEntity)blockEntity;
            treadmillBlockEntity.onSteppedOn(pos, state, entity);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (type != SyncBlockEntities.TREADMILL || !TreadmillBlock.isBack(state)) {
            return null;
        }
        return world.f_46443_ ? TickableBlockEntity::clientTicker : TickableBlockEntity::serverTicker;
    }

    public static Direction getDirectionTowardsOtherPart(Part part, Direction direction) {
        return part == Part.BACK ? direction : direction.m_122424_();
    }

    static {
        VoxelShape TRACK_NORTH_SOUTH = Block.m_49796_((double)1.5, (double)0.0, (double)0.0, (double)14.5, (double)4.0, (double)16.0);
        VoxelShape TRACK_EAST_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)1.5, (double)16.0, (double)4.0, (double)14.5);
        VoxelShape LEFT_SIDE_GUARD_NORTH_BACK = Block.m_49796_((double)1.5, (double)0.0, (double)0.0, (double)1.6, (double)8.3, (double)7.4);
        VoxelShape RIGHT_SIDE_GUARD_NORTH_BACK = Block.m_49796_((double)14.4, (double)0.0, (double)0.0, (double)14.5, (double)8.3, (double)7.4);
        VoxelShape LEFT_SIDE_GUARD_NORTH_FRONT = Block.m_49796_((double)1.5, (double)0.0, (double)7.5, (double)1.6, (double)8.7, (double)16.0);
        VoxelShape RIGHT_SIDE_GUARD_NORTH_FRONT = Block.m_49796_((double)14.4, (double)0.0, (double)7.5, (double)14.5, (double)8.7, (double)16.0);
        VoxelShape DASHBOARD_NORTH_FRONT = Block.m_49796_((double)1.5, (double)0.0, (double)2.0, (double)14.5, (double)8.5, (double)3.0);
        VoxelShape LEFT_SIDE_GUARD_SOUTH_BACK = Block.m_49796_((double)1.5, (double)0.0, (double)8.6, (double)1.6, (double)8.3, (double)16.0);
        VoxelShape RIGHT_SIDE_GUARD_SOUTH_BACK = Block.m_49796_((double)14.4, (double)0.0, (double)8.6, (double)14.5, (double)8.3, (double)16.0);
        VoxelShape LEFT_SIDE_GUARD_SOUTH_FRONT = Block.m_49796_((double)1.5, (double)0.0, (double)0.0, (double)1.6, (double)8.7, (double)8.5);
        VoxelShape RIGHT_SIDE_GUARD_SOUTH_FRONT = Block.m_49796_((double)14.4, (double)0.0, (double)0.0, (double)14.5, (double)8.7, (double)8.5);
        VoxelShape DASHBOARD_SOUTH_FRONT = Block.m_49796_((double)1.5, (double)0.0, (double)13.0, (double)14.5, (double)8.5, (double)14.0);
        VoxelShape LEFT_SIDE_GUARD_EAST_BACK = Block.m_49796_((double)8.6, (double)0.0, (double)1.5, (double)16.0, (double)8.3, (double)1.6);
        VoxelShape RIGHT_SIDE_GUARD_EAST_BACK = Block.m_49796_((double)8.6, (double)0.0, (double)14.4, (double)16.0, (double)8.3, (double)14.5);
        VoxelShape LEFT_SIDE_GUARD_EAST_FRONT = Block.m_49796_((double)0.0, (double)0.0, (double)1.5, (double)8.5, (double)8.7, (double)1.6);
        VoxelShape RIGHT_SIDE_GUARD_EAST_FRONT = Block.m_49796_((double)0.0, (double)0.0, (double)14.4, (double)8.5, (double)8.7, (double)14.5);
        VoxelShape DASHBOARD_EAST_FRONT = Block.m_49796_((double)13.0, (double)0.0, (double)1.5, (double)14.0, (double)8.5, (double)14.5);
        VoxelShape LEFT_SIDE_GUARD_WEST_BACK = Block.m_49796_((double)0.0, (double)0.0, (double)1.5, (double)7.4, (double)8.3, (double)1.6);
        VoxelShape RIGHT_SIDE_GUARD_WEST_BACK = Block.m_49796_((double)0.0, (double)0.0, (double)14.4, (double)7.4, (double)8.3, (double)14.5);
        VoxelShape LEFT_SIDE_GUARD_WEST_FRONT = Block.m_49796_((double)7.5, (double)0.0, (double)1.5, (double)16.0, (double)8.7, (double)1.6);
        VoxelShape RIGHT_SIDE_GUARD_WEST_FRONT = Block.m_49796_((double)7.5, (double)0.0, (double)14.4, (double)16.0, (double)8.7, (double)14.5);
        VoxelShape DASHBOARD_WEST_FRONT = Block.m_49796_((double)2.0, (double)0.0, (double)1.5, (double)3.0, (double)8.5, (double)14.5);
        NORTH_SHAPE_BACK = Shapes.m_83124_((VoxelShape)TRACK_NORTH_SOUTH, (VoxelShape[])new VoxelShape[]{LEFT_SIDE_GUARD_NORTH_BACK, RIGHT_SIDE_GUARD_NORTH_BACK}).m_83296_();
        NORTH_SHAPE_FRONT = Shapes.m_83124_((VoxelShape)TRACK_NORTH_SOUTH, (VoxelShape[])new VoxelShape[]{LEFT_SIDE_GUARD_NORTH_FRONT, RIGHT_SIDE_GUARD_NORTH_FRONT, DASHBOARD_NORTH_FRONT}).m_83296_();
        SOUTH_SHAPE_BACK = Shapes.m_83124_((VoxelShape)TRACK_NORTH_SOUTH, (VoxelShape[])new VoxelShape[]{LEFT_SIDE_GUARD_SOUTH_BACK, RIGHT_SIDE_GUARD_SOUTH_BACK}).m_83296_();
        SOUTH_SHAPE_FRONT = Shapes.m_83124_((VoxelShape)TRACK_NORTH_SOUTH, (VoxelShape[])new VoxelShape[]{LEFT_SIDE_GUARD_SOUTH_FRONT, RIGHT_SIDE_GUARD_SOUTH_FRONT, DASHBOARD_SOUTH_FRONT}).m_83296_();
        EAST_SHAPE_BACK = Shapes.m_83124_((VoxelShape)TRACK_EAST_WEST, (VoxelShape[])new VoxelShape[]{LEFT_SIDE_GUARD_EAST_BACK, RIGHT_SIDE_GUARD_EAST_BACK}).m_83296_();
        EAST_SHAPE_FRONT = Shapes.m_83124_((VoxelShape)TRACK_EAST_WEST, (VoxelShape[])new VoxelShape[]{LEFT_SIDE_GUARD_EAST_FRONT, RIGHT_SIDE_GUARD_EAST_FRONT, DASHBOARD_EAST_FRONT}).m_83296_();
        WEST_SHAPE_BACK = Shapes.m_83124_((VoxelShape)TRACK_EAST_WEST, (VoxelShape[])new VoxelShape[]{LEFT_SIDE_GUARD_WEST_BACK, RIGHT_SIDE_GUARD_WEST_BACK}).m_83296_();
        WEST_SHAPE_FRONT = Shapes.m_83124_((VoxelShape)TRACK_EAST_WEST, (VoxelShape[])new VoxelShape[]{LEFT_SIDE_GUARD_WEST_FRONT, RIGHT_SIDE_GUARD_WEST_FRONT, DASHBOARD_WEST_FRONT}).m_83296_();
    }

    public static enum Part implements StringRepresentable
    {
        FRONT("front"),
        BACK("back");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

