/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block.entity;

import dev.kir.sync.api.networking.ShellDestroyedPacket;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateContainer;
import dev.kir.sync.api.shell.ShellStateManager;
import dev.kir.sync.block.AbstractShellContainerBlock;
import dev.kir.sync.block.entity.BooleanAnimator;
import dev.kir.sync.block.entity.DoubleBlockEntity;
import dev.kir.sync.block.entity.TickableBlockEntity;
import dev.kir.sync.item.SimpleInventory;
import dev.kir.sync.util.ItemUtil;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShellContainerBlockEntity
extends BlockEntity
implements ShellStateContainer,
DoubleBlockEntity,
TickableBlockEntity,
Container {
    protected final BooleanAnimator doorAnimator;
    protected ShellState shell;
    protected DyeColor color;
    protected int progressComparatorOutput;
    protected int inventoryComparatorOutput;
    private AbstractShellContainerBlockEntity bottomPart;
    private ShellState syncedShell;
    private BlockPos syncedShellPos;
    private DyeColor syncedShellColor;
    private float syncedShellProgress;
    private DyeColor syncedColor;
    private boolean inventoryDirty;
    private boolean visibleInventoryDirty;

    public AbstractShellContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.doorAnimator = new BooleanAnimator(AbstractShellContainerBlock.isOpen(state));
    }

    @Override
    public void setShellState(ShellState shell) {
        this.shell = shell;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.f_58858_ != null && this.m_58900_() != null) {
            this.checkShellState(this.f_58857_, this.f_58858_, this.m_58900_());
        }
    }

    @Override
    public ShellState getShellState() {
        return this.shell;
    }

    @Override
    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public int getProgressComparatorOutput() {
        return this.getBottomPart().map(x -> x.progressComparatorOutput).orElse(0);
    }

    public int getInventoryComparatorOutput() {
        return this.getBottomPart().map(x -> x.inventoryComparatorOutput).orElse(0);
    }

    protected ShellStateManager getShellStateManager() {
        return (ShellStateManager)Objects.requireNonNull(this.f_58857_).m_7654_();
    }

    protected Optional<AbstractShellContainerBlockEntity> getBottomPart() {
        if (this.bottomPart == null && this.f_58857_ != null) {
            AbstractShellContainerBlockEntity x;
            BlockEntity blockEntity;
            this.bottomPart = AbstractShellContainerBlock.isBottom(this.m_58900_()) ? this : ((blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(Direction.DOWN))) instanceof AbstractShellContainerBlockEntity ? (x = (AbstractShellContainerBlockEntity)blockEntity) : null);
        }
        return Optional.ofNullable(this.bottomPart);
    }

    @Override
    public void onServerTick(Level world, BlockPos pos, BlockState state) {
        this.checkShellState(world, pos, state);
    }

    private void checkShellState(Level world, BlockPos pos, BlockState state) {
        if (this.shell != null && this.shell.getColor() != this.color) {
            this.shell.setColor(this.color);
        }
        if (this.requiresSync()) {
            this.updateShell(this.shell != this.syncedShell, !this.visibleInventoryDirty);
            this.updateComparatorOutput(world, pos, state);
            this.syncedShellPos = this.shell == null ? null : this.shell.getPos();
            this.syncedShellColor = this.shell == null ? null : this.shell.getColor();
            this.syncedShellProgress = this.shell == null ? -1.0f : this.shell.getProgress();
            this.syncedShell = this.shell;
            this.syncedColor = this.color;
            this.inventoryDirty = false;
            this.visibleInventoryDirty = false;
            this.sync();
            world.m_151543_(pos);
        }
        if (this.inventoryDirty) {
            this.updateComparatorOutput(world, pos, state);
            this.inventoryDirty = false;
            world.m_151543_(pos);
        }
    }

    private boolean requiresSync() {
        return this.visibleInventoryDirty || this.syncedShell != this.shell || this.syncedColor != this.color || this.shell != null && (!this.shell.getPos().equals((Object)this.syncedShellPos) || !Objects.equals(this.shell.getColor(), this.syncedShellColor) || this.shell.getProgress() != this.syncedShellProgress);
    }

    private void updateShell(boolean isNew, boolean partialUpdate) {
        ShellStateManager shellManager = this.getShellStateManager();
        if (isNew) {
            shellManager.remove(this.syncedShell);
            shellManager.add(this.shell);
        } else if (partialUpdate) {
            shellManager.update(this.shell);
        } else {
            shellManager.add(this.shell);
        }
    }

    private void updateComparatorOutput(Level world, BlockPos pos, BlockState state) {
        int currentProgressOutput = this.shell == null ? 0 : Mth.m_14045_((int)((int)(this.shell.getProgress() * 15.0f)), (int)1, (int)15);
        int currentInventoryOutput = this.shell == null ? 0 : AbstractContainerMenu.m_38938_((Container)this.shell.getInventory());
        BlockPos topPartPos = pos.m_121945_(AbstractShellContainerBlock.getDirectionTowardsAnotherPart(state));
        BlockState topPartState = world.m_8055_(topPartPos);
        if (this.progressComparatorOutput != currentProgressOutput) {
            this.progressComparatorOutput = currentProgressOutput;
            if (state.m_61143_(AbstractShellContainerBlock.OUTPUT) == AbstractShellContainerBlock.ComparatorOutputType.PROGRESS) {
                world.m_46717_(pos, state.m_60734_());
            }
            if (topPartState.m_61138_(AbstractShellContainerBlock.OUTPUT) && topPartState.m_61143_(AbstractShellContainerBlock.OUTPUT) == AbstractShellContainerBlock.ComparatorOutputType.PROGRESS) {
                world.m_46717_(topPartPos, topPartState.m_60734_());
            }
        }
        if (this.inventoryComparatorOutput != currentInventoryOutput) {
            this.inventoryComparatorOutput = currentInventoryOutput;
            if (state.m_61143_(AbstractShellContainerBlock.OUTPUT) == AbstractShellContainerBlock.ComparatorOutputType.INVENTORY) {
                world.m_46717_(pos, state.m_60734_());
            }
            if (topPartState.m_61138_(AbstractShellContainerBlock.OUTPUT) && topPartState.m_61143_(AbstractShellContainerBlock.OUTPUT) == AbstractShellContainerBlock.ComparatorOutputType.INVENTORY) {
                world.m_46717_(topPartPos, topPartState.m_60734_());
            }
        }
    }

    @Override
    public void onClientTick(Level world, BlockPos pos, BlockState state) {
        this.doorAnimator.setValue(AbstractShellContainerBlock.isOpen(state));
        this.doorAnimator.step();
    }

    public void onBreak(Level world, BlockPos pos) {
        if (this.shell != null && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.getShellStateManager().remove(this.shell);
            this.destroyShell(serverWorld, pos);
        }
    }

    protected void destroyShell(ServerLevel world, BlockPos pos) {
        if (this.shell != null) {
            this.shell.drop(world, pos);
            new ShellDestroyedPacket(pos).send(PlayerLookup.around((ServerLevel)world, (Vec3i)pos, (double)32.0));
            this.shell = null;
        }
    }

    public abstract InteractionResult onUse(Level var1, BlockPos var2, Player var3, InteractionHand var4);

    @Environment(value=EnvType.CLIENT)
    public float getDoorOpenProgress(float tickDelta) {
        return this.getBottomPart().map(x -> Float.valueOf(x.doorAnimator.getProgress(tickDelta))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        return AbstractShellContainerBlock.getShellContainerHalf(state);
    }

    protected void sync() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.m_7726_().m_8450_(this.f_58858_);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.shell != null) {
            nbt.m_128365_("shell", (Tag)this.shell.writeNbt(new CompoundTag()));
        }
        nbt.m_128405_("color", this.color == null ? -1 : this.color.m_41060_());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.shell = nbt.m_128441_("shell") ? ShellState.fromNbt(nbt.m_128469_("shell")) : null;
        int colorId = nbt.m_128425_("color", 3) ? nbt.m_128451_("color") : -1;
        this.color = colorId == -1 ? null : DyeColor.m_41053_((int)colorId);
    }

    private static int reorderSlotIndex(int slot, SimpleInventory inventory) {
        int mainSize = inventory.main.size();
        int armorSize = inventory.armor.size();
        int offHandSize = inventory.offHand.size();
        return slot >= 0 && slot < armorSize ? slot + mainSize : (slot >= armorSize && slot < armorSize + offHandSize ? slot + mainSize : slot - armorSize - offHandSize);
    }

    private static boolean isVisibleSlot(int slot, SimpleInventory inventory) {
        int armorSize = inventory.armor.size();
        int offHandSize = inventory.offHand.size();
        return slot >= 0 && slot <= armorSize + offHandSize;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        boolean isOffHandSlot;
        boolean isArmorSlot;
        AbstractShellContainerBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null) {
            return false;
        }
        SimpleInventory inventory = bottom.shell.getInventory();
        int armorSize = inventory.armor.size();
        boolean bl = isArmorSlot = slot >= 0 && slot < armorSize;
        if (isArmorSlot) {
            EquipmentSlot equipmentSlot = ItemUtil.getPreferredEquipmentSlot(stack);
            return ItemUtil.isArmor(stack) && equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR && slot == equipmentSlot.m_20749_();
        }
        boolean bl2 = isOffHandSlot = slot >= armorSize && slot < armorSize + inventory.offHand.size();
        if (isOffHandSlot) {
            return ItemUtil.getPreferredEquipmentSlot(stack) == EquipmentSlot.OFFHAND || inventory.main.stream().noneMatch(x -> x.m_41619_() || x.m_41613_() + stack.m_41613_() <= x.m_41741_() && ItemStack.m_150942_((ItemStack)x, (ItemStack)stack));
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.getBottomPart().filter(x -> x.shell != null).map(x -> x.shell.getInventory().m_8020_(AbstractShellContainerBlockEntity.reorderSlotIndex(slot, x.shell.getInventory()))).orElse(ItemStack.f_41583_);
    }

    public void m_6836_(int slot, ItemStack stack) {
        AbstractShellContainerBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null || bottom.shell.getProgress() < 1.0f) {
            return;
        }
        SimpleInventory inventory = bottom.shell.getInventory();
        inventory.m_6836_(AbstractShellContainerBlockEntity.reorderSlotIndex(slot, inventory), stack);
        bottom.inventoryDirty = true;
        bottom.visibleInventoryDirty |= AbstractShellContainerBlockEntity.isVisibleSlot(slot, inventory);
    }

    public ItemStack m_7407_(int slot, int amount) {
        AbstractShellContainerBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null) {
            return ItemStack.f_41583_;
        }
        SimpleInventory inventory = bottom.shell.getInventory();
        ItemStack removed = inventory.m_7407_(AbstractShellContainerBlockEntity.reorderSlotIndex(slot, inventory), amount);
        bottom.inventoryDirty = true;
        bottom.visibleInventoryDirty = bottom.visibleInventoryDirty | (!removed.m_41619_() && AbstractShellContainerBlockEntity.isVisibleSlot(slot, inventory));
        return removed;
    }

    public ItemStack m_8016_(int slot) {
        AbstractShellContainerBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null) {
            return ItemStack.f_41583_;
        }
        SimpleInventory inventory = bottom.shell.getInventory();
        ItemStack removed = inventory.m_8016_(AbstractShellContainerBlockEntity.reorderSlotIndex(slot, inventory));
        bottom.inventoryDirty = true;
        bottom.visibleInventoryDirty = bottom.visibleInventoryDirty | (!removed.m_41619_() && AbstractShellContainerBlockEntity.isVisibleSlot(slot, inventory));
        return removed;
    }

    public void m_6211_() {
        AbstractShellContainerBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null) {
            return;
        }
        bottom.shell.getInventory().m_6211_();
        bottom.inventoryDirty = true;
        bottom.visibleInventoryDirty = true;
    }

    public int m_6643_() {
        return this.getBottomPart().map(x -> x.shell == null || x.shell.getProgress() < 1.0f ? 0 : x.shell.getInventory().m_6643_()).orElse(0);
    }

    public boolean m_7983_() {
        return this.getBottomPart().map(x -> x.shell == null || x.shell.getInventory().m_7983_()).orElse(true);
    }

    public boolean m_6542_(Player player) {
        return false;
    }
}

