/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block.entity;

import dev.kir.sync.Sync;
import dev.kir.sync.api.event.PlayerSyncEvents;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateContainer;
import dev.kir.sync.block.AbstractShellContainerBlock;
import dev.kir.sync.block.ShellConstructorBlock;
import dev.kir.sync.block.entity.AbstractShellContainerBlockEntity;
import dev.kir.sync.block.entity.SyncBlockEntities;
import dev.kir.sync.config.SyncConfig;
import dev.kir.sync.util.BlockPosUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class ShellConstructorBlockEntity
extends AbstractShellContainerBlockEntity
implements EnergyStorage {
    public ShellConstructorBlockEntity(BlockPos pos, BlockState state) {
        super(SyncBlockEntities.SHELL_CONSTRUCTOR, pos, state);
    }

    @Override
    public void onServerTick(Level world, BlockPos pos, BlockState state) {
        super.onServerTick(world, pos, state);
        if (ShellConstructorBlock.isOpen(state)) {
            ShellConstructorBlock.setOpen(state, world, pos, BlockPosUtil.hasPlayerInside(pos, (EntityGetter)world));
        }
    }

    @Override
    public InteractionResult onUse(Level world, BlockPos pos, Player player, InteractionHand hand) {
        PlayerSyncEvents.ShellConstructionFailureReason failureReason = this.beginShellConstruction(player);
        if (failureReason == null) {
            return InteractionResult.SUCCESS;
        }
        player.m_5661_(failureReason.toText(), true);
        return InteractionResult.CONSUME;
    }

    @Nullable
    private PlayerSyncEvents.ShellConstructionFailureReason beginShellConstruction(Player player) {
        PlayerSyncEvents.ShellConstructionFailureReason failureReason;
        PlayerSyncEvents.ShellConstructionFailureReason shellConstructionFailureReason = failureReason = this.shell == null ? ((PlayerSyncEvents.AllowShellConstruction)PlayerSyncEvents.ALLOW_SHELL_CONSTRUCTION.invoker()).allowShellConstruction(player, this) : PlayerSyncEvents.ShellConstructionFailureReason.OCCUPIED;
        if (failureReason != null) {
            return failureReason;
        }
        if (player instanceof ServerPlayer) {
            boolean hasTotemOfUndying;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SyncConfig config = Sync.getConfig();
            float damage = serverPlayer.f_8924_.m_7035_() ? config.hardcoreFingerstickDamage() : config.fingerstickDamage();
            boolean isCreative = !serverPlayer.f_8941_.m_9290_().m_46409_();
            boolean isLowOnHealth = player.m_21223_() + player.m_6103_() <= damage;
            boolean bl = hasTotemOfUndying = player.m_21205_().m_150930_(Items.f_42747_) || player.m_21206_().m_150930_(Items.f_42747_);
            if (isLowOnHealth && !isCreative && !hasTotemOfUndying && config.warnPlayerInsteadOfKilling()) {
                return PlayerSyncEvents.ShellConstructionFailureReason.NOT_ENOUGH_HEALTH;
            }
            player.m_6469_(this.f_58857_.m_269111_().m_269555_(), damage);
            this.shell = ShellState.empty(serverPlayer, this.f_58858_);
            if (isCreative && config.enableInstantShellConstruction()) {
                this.shell.setProgress(1.0f);
            }
        }
        return null;
    }

    public long getAmount() {
        ShellConstructorBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null) {
            return 0L;
        }
        long cap = Sync.getConfig().shellConstructorCapacity();
        return (long)(bottom.shell.getProgress() * (float)cap);
    }

    public long getCapacity() {
        ShellConstructorBlockEntity bottom = this.getBottomPart().orElse(null);
        return bottom != null && bottom.shell != null ? Sync.getConfig().shellConstructorCapacity() : 0L;
    }

    public boolean supportsInsertion() {
        return true;
    }

    public boolean supportsExtraction() {
        return false;
    }

    public long insert(long amount, TransactionContext context) {
        ShellConstructorBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null || bottom.shell == null) {
            return 0L;
        }
        if (ShellConstructorBlock.isOpen(bottom.m_58900_())) {
            return 0L;
        }
        if (bottom.shell.getProgress() >= 1.0f) {
            return 0L;
        }
        long capacity = Sync.getConfig().shellConstructorCapacity();
        long missingFE = (long)Math.ceil((1.0f - bottom.shell.getProgress()) * (float)capacity);
        long accepted = Math.min(amount, missingFE);
        if (accepted <= 0L) {
            return 0L;
        }
        context.addCloseCallback((txn, result) -> {
            if (result.wasCommitted()) {
                bottom.shell.setProgress(bottom.shell.getProgress() + (float)accepted / (float)capacity);
            }
        });
        return accepted;
    }

    public long extract(long maxAmount, TransactionContext context) {
        return 0L;
    }

    static {
        ShellStateContainer.LOOKUP.registerForBlockEntity((x, s) -> x.m_58898_() && AbstractShellContainerBlock.isBottom(x.m_58900_()) && (s == null || s.equals(x.getShellState())) ? x : null, SyncBlockEntities.SHELL_CONSTRUCTOR);
        EnergyStorage.SIDED.registerForBlockEntities((x, __) -> (EnergyStorage)x, new BlockEntityType[]{SyncBlockEntities.SHELL_CONSTRUCTOR});
    }
}

