/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block.entity;

import dev.kir.sync.Sync;
import dev.kir.sync.api.event.PlayerSyncEvents;
import dev.kir.sync.api.shell.ShellStateContainer;
import dev.kir.sync.block.AbstractShellContainerBlock;
import dev.kir.sync.block.ShellStorageBlock;
import dev.kir.sync.block.entity.AbstractShellContainerBlockEntity;
import dev.kir.sync.block.entity.BooleanAnimator;
import dev.kir.sync.block.entity.SyncBlockEntities;
import dev.kir.sync.client.gui.ShellSelectorGUI;
import dev.kir.sync.config.SyncConfig;
import dev.kir.sync.util.BlockPosUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import team.reborn.energy.api.EnergyStorage;

public class ShellStorageBlockEntity
extends AbstractShellContainerBlockEntity
implements EnergyStorage {
    private EntityState entityState = EntityState.NONE;
    private int ticksWithoutPower;
    private long storedEnergy;
    private final BooleanAnimator connectorAnimator = new BooleanAnimator(false);

    public ShellStorageBlockEntity(BlockPos pos, BlockState state) {
        super(SyncBlockEntities.SHELL_STORAGE, pos, state);
    }

    public DyeColor getIndicatorColor() {
        if (this.f_58857_ != null && ShellStorageBlock.isPowered(this.m_58900_())) {
            return this.color == null ? DyeColor.LIME : this.color;
        }
        return DyeColor.RED;
    }

    @Environment(value=EnvType.CLIENT)
    public float getConnectorProgress(float tickDelta) {
        return this.getBottomPart().map(x -> Float.valueOf(((ShellStorageBlockEntity)x).connectorAnimator.getProgress(tickDelta))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void onServerTick(Level world, BlockPos pos, BlockState state) {
        boolean isReceivingRedstonePower;
        super.onServerTick(world, pos, state);
        SyncConfig config = Sync.getConfig();
        boolean infinitePower = config.shellStorageConsumption() == 0L;
        boolean bl = isReceivingRedstonePower = !infinitePower && config.shellStorageAcceptsRedstone() && ShellStorageBlock.isEnabled(state);
        boolean hasEnergy = infinitePower ? true : this.storedEnergy > 0L;
        boolean isPowered = infinitePower || isReceivingRedstonePower || hasEnergy;
        boolean shouldBeOpen = isPowered && this.getBottomPart().map(x -> x.shell == null).orElse(true) != false;
        ShellStorageBlock.setPowered(state, world, pos, isPowered);
        ShellStorageBlock.setOpen(state, world, pos, shouldBeOpen);
        if (!infinitePower) {
            if (this.shell != null && !isPowered) {
                ++this.ticksWithoutPower;
                if (this.ticksWithoutPower >= config.shellStorageMaxUnpoweredLifespan()) {
                    this.destroyShell((ServerLevel)world, pos);
                }
            } else {
                this.ticksWithoutPower = 0;
            }
        }
        if (!infinitePower && !isReceivingRedstonePower && hasEnergy) {
            this.storedEnergy = (long)Mth.m_14036_((float)(this.storedEnergy - config.shellStorageConsumption()), (float)0.0f, (float)config.shellStorageCapacity());
        }
    }

    @Override
    public void onClientTick(Level world, BlockPos pos, BlockState state) {
        super.onClientTick(world, pos, state);
        this.connectorAnimator.setValue(this.shell != null);
        this.connectorAnimator.step();
        if (this.entityState == EntityState.LEAVING || this.entityState == EntityState.CHILLING) {
            this.entityState = BlockPosUtil.hasPlayerInside(pos, (EntityGetter)world) ? this.entityState : EntityState.NONE;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void onEntityCollisionClient(Entity entity, BlockState state) {
        Minecraft client = Minecraft.m_91087_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.entityState == EntityState.NONE) {
            boolean isInside = BlockPosUtil.isEntityInside(entity, this.f_58858_);
            PlayerSyncEvents.ShellSelectionFailureReason failureReason = !isInside && client.f_91074_ == entity ? ((PlayerSyncEvents.AllowShellSelection)PlayerSyncEvents.ALLOW_SHELL_SELECTION.invoker()).allowShellSelection(player, this) : null;
            EntityState entityState = this.entityState = isInside || failureReason != null ? EntityState.CHILLING : EntityState.ENTERING;
            if (failureReason != null) {
                player.m_5661_(failureReason.toText(), true);
            }
        } else if (this.entityState != EntityState.CHILLING && client.f_91080_ == null) {
            BlockPosUtil.moveEntity(entity, this.f_58858_, (Direction)state.m_61143_((Property)ShellStorageBlock.FACING), this.entityState == EntityState.ENTERING);
        }
        if (this.entityState == EntityState.ENTERING && client.f_91074_ == entity && client.f_91080_ == null && BlockPosUtil.isEntityInside(entity, this.f_58858_)) {
            client.m_91152_((Screen)new ShellSelectorGUI(() -> {
                this.entityState = EntityState.LEAVING;
            }, () -> {
                this.entityState = EntityState.CHILLING;
            }));
        }
    }

    @Override
    public InteractionResult onUse(Level world, BlockPos pos, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (stack.m_41613_() > 0 && item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            stack.m_41774_(1);
            this.color = dye.m_41089_();
        }
        return InteractionResult.SUCCESS;
    }

    public boolean supportsInsertion() {
        return Sync.getConfig().shellStorageConsumption() != 0L;
    }

    public boolean supportsExtraction() {
        return false;
    }

    public long insert(long amount, TransactionContext context) {
        if (Sync.getConfig().shellStorageConsumption() == 0L) {
            return 0L;
        }
        ShellStorageBlockEntity bottom = this.getBottomPart().orElse(null);
        if (bottom == null) {
            return 0L;
        }
        long capacity = bottom.getCapacity();
        long maxEnergy = (long)Mth.m_14036_((float)(capacity - bottom.storedEnergy), (float)0.0f, (float)capacity);
        long inserted = (long)Mth.m_14036_((float)amount, (float)0.0f, (float)maxEnergy);
        context.addCloseCallback((ctx, result) -> {
            if (result.wasCommitted()) {
                bottom.storedEnergy += inserted;
            }
        });
        return inserted;
    }

    public long extract(long amount, TransactionContext context) {
        return 0L;
    }

    public long getAmount() {
        return 0L;
    }

    public long getCapacity() {
        return Sync.getConfig().shellStorageConsumption() == 0L ? 0L : Sync.getConfig().shellStorageCapacity();
    }

    static {
        ShellStateContainer.LOOKUP.registerForBlockEntity((x, s) -> x.m_58898_() && AbstractShellContainerBlock.isBottom(x.m_58900_()) && (s == null || s.equals(x.getShellState())) ? x : null, SyncBlockEntities.SHELL_STORAGE);
        EnergyStorage.SIDED.registerForBlockEntities((x, __) -> (EnergyStorage)x, new BlockEntityType[]{SyncBlockEntities.SHELL_STORAGE});
    }

    private static enum EntityState {
        NONE,
        ENTERING,
        CHILLING,
        LEAVING;

    }
}

