/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface TickableBlockEntity {
    public static <T extends BlockEntity> void clientTicker(Level world, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof TickableBlockEntity) {
            TickableBlockEntity tickable = (TickableBlockEntity)blockEntity;
            tickable.onClientTick(world, pos, state);
        }
    }

    public static <T extends BlockEntity> void serverTicker(Level world, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof TickableBlockEntity) {
            TickableBlockEntity tickable = (TickableBlockEntity)blockEntity;
            tickable.onServerTick(world, pos, state);
        }
    }

    default public void onClientTick(Level world, BlockPos pos, BlockState state) {
        this.onTick(world, pos, state);
    }

    default public void onServerTick(Level world, BlockPos pos, BlockState state) {
        this.onTick(world, pos, state);
    }

    default public void onTick(Level world, BlockPos pos, BlockState state) {
    }
}

