/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block.entity;

import dev.kir.sync.Sync;
import dev.kir.sync.api.event.EntityFitnessEvents;
import dev.kir.sync.block.TreadmillBlock;
import dev.kir.sync.block.entity.DoubleBlockEntity;
import dev.kir.sync.block.entity.SyncBlockEntities;
import dev.kir.sync.block.entity.TickableBlockEntity;
import dev.kir.sync.config.SyncConfig;
import dev.kir.sync.easteregg.technoblade.TechnobladeManager;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class TreadmillBlockEntity
extends BlockEntity
implements DoubleBlockEntity,
TickableBlockEntity,
EnergyStorage {
    private static final int MAX_RUNNING_TIME = 18000;
    private static final double MAX_SQUARED_DISTANCE = 0.5;
    private static final Map<EntityType<? extends Entity>, Long> ENERGY_MAP = Sync.getConfig().energyMap().stream().collect(Collectors.toUnmodifiableMap(SyncConfig.EnergyMapEntry::getEntityType, SyncConfig.EnergyMapEntry::outputEnergyQuantity, (a, b) -> a));
    private UUID runnerUUID;
    private Integer runnerId;
    private Entity runner;
    private int runningTime;
    private long storedEnergy;
    private long producibleEnergyQuantity;
    private TreadmillBlockEntity cachedBackPart;

    public TreadmillBlockEntity(BlockPos pos, BlockState state) {
        super(SyncBlockEntities.TREADMILL, pos, state);
    }

    private void setRunner(Entity entity) {
        if (this.runner == entity) {
            return;
        }
        if (this.runner != null) {
            ((EntityFitnessEvents.StopRunning)EntityFitnessEvents.STOP_RUNNING.invoker()).onStopRunning(this.runner, this);
        }
        if (entity == null) {
            this.runningTime = 0;
            this.producibleEnergyQuantity = 0L;
        }
        this.runner = entity;
        if (this.runner != null) {
            ((EntityFitnessEvents.StartRunning)EntityFitnessEvents.START_RUNNING.invoker()).onStartRunning(this.runner, this);
        }
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            TechnobladeManager.refreshTechnobladeStatus(entity, this.f_58858_);
        } else {
            this.m_6596_();
            this.sync();
        }
    }

    @Override
    public void onClientTick(Level world, BlockPos pos, BlockState state) {
        if (this.runnerId != null) {
            this.setRunner(world.m_6815_(this.runnerId.intValue()));
            this.runnerId = null;
        }
        if (this.runner == null) {
            return;
        }
        Entity entity = this.runner;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_267362_.m_267566_((float)this.runningTime / 18000.0f, 1.0f);
        }
        this.runningTime = Math.min(++this.runningTime, 18000);
    }

    @Override
    public void onServerTick(Level world, BlockPos pos, BlockState state) {
        Entity entity;
        if (this.runnerUUID != null && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.setRunner(serverWorld.m_8791_(this.runnerUUID));
            this.runnerUUID = null;
        }
        if (this.runner == null) {
            return;
        }
        Direction face = (Direction)state.m_61143_((Property)TreadmillBlock.f_54117_);
        Vec3 anchor = TreadmillBlockEntity.computeTreadmillPivot(pos, face);
        if (!TreadmillBlockEntity.isValidEntity(this.runner) || !TreadmillBlockEntity.isEntityNear(this.runner, anchor)) {
            this.setRunner(null);
            return;
        }
        if (!this.runner.m_142389_()) {
            float yaw = face.m_122435_();
            this.runner.m_19890_(anchor.f_82479_, anchor.f_82480_, anchor.f_82481_, yaw, 0.0f);
            this.runner.m_5616_(yaw);
            this.runner.m_5618_(yaw);
            this.runner.m_146922_(yaw);
            this.runner.f_19859_ = yaw;
        }
        if ((entity = this.runner) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_21310_(0);
        }
        this.storedEnergy = this.producibleEnergyQuantity * (long)(1.0 + 0.5 * (double)this.runningTime / 18000.0);
        this.transferEnergy(world, pos);
        if (this.runningTime < 18000) {
            ++this.runningTime;
            if (this.runningTime % 1000 == 0) {
                this.m_6596_();
                this.sync();
            }
        }
    }

    public void onSteppedOn(BlockPos pos, BlockState state, Entity entity) {
        Long energy;
        if (this.runner != null || !TreadmillBlockEntity.isEntityNear(entity, TreadmillBlockEntity.computeTreadmillPivot(pos, (Direction)state.m_61143_((Property)TreadmillBlock.f_54117_)))) {
            return;
        }
        Long l = energy = TreadmillBlockEntity.isValidEntity(entity) ? TreadmillBlockEntity.getOutputEnergyQuantityForEntity(entity, this) : null;
        if (energy != null) {
            this.setRunner(entity);
            this.producibleEnergyQuantity = energy;
        }
    }

    public boolean isOverheated() {
        return this.runner != null && this.runningTime >= 18000;
    }

    public long getAmount() {
        TreadmillBlockEntity back = this.getBackPart();
        return back == null ? 0L : back.storedEnergy;
    }

    public long getCapacity() {
        TreadmillBlockEntity back = this.getBackPart();
        if (back == null || back.runner == null) {
            return 0L;
        }
        return back.producibleEnergyQuantity * (long)(1.0 + 0.5 * (double)back.runningTime / 18000.0);
    }

    public boolean supportsInsertion() {
        return false;
    }

    public boolean supportsExtraction() {
        return true;
    }

    public long insert(long maxAmount, TransactionContext context) {
        return 0L;
    }

    public long extract(long maxAmount, TransactionContext context) {
        TreadmillBlockEntity back = this.getBackPart();
        if (back == null) {
            return 0L;
        }
        long extracted = Math.min(back.storedEnergy, maxAmount);
        context.addCloseCallback((ctx, result) -> {
            if (result.wasCommitted()) {
                back.storedEnergy -= extracted;
            }
        });
        return extracted;
    }

    private void transferEnergy(Level world, BlockPos pos) {
        TreadmillBlockEntity back = this.getBackPart();
        if (back == null) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            for (Direction direction : Direction.values()) {
                EnergyStorage target = (EnergyStorage)EnergyStorage.SIDED.find(world, pos.m_121945_(direction), (Object)direction.m_122424_());
                if (target == null || !target.supportsInsertion()) continue;
                EnergyStorageUtil.move((EnergyStorage)back, (EnergyStorage)target, (long)Long.MAX_VALUE, null);
                if (back.storedEnergy > 0L) continue;
                return;
            }
            pos = pos.m_121945_((Direction)this.m_58900_().m_61143_((Property)TreadmillBlock.f_54117_));
        }
    }

    @Override
    public DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        return TreadmillBlock.getTreadmillPart(state);
    }

    private TreadmillBlockEntity getBackPart() {
        if (this.cachedBackPart != null || this.f_58857_ == null) {
            return this.cachedBackPart;
        }
        if (TreadmillBlock.isBack(this.m_58900_())) {
            this.cachedBackPart = this;
        } else {
            BlockPos backPartPos = this.f_58858_.m_121945_(((Direction)this.m_58900_().m_61143_((Property)TreadmillBlock.f_54117_)).m_122424_());
            this.cachedBackPart = this.f_58857_.m_141902_(backPartPos, SyncBlockEntities.TREADMILL).orElse(null);
        }
        return this.cachedBackPart;
    }

    protected void sync() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.m_7726_().m_8450_(this.f_58858_);
        }
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.runnerUUID = nbt.m_128403_("runner") ? nbt.m_128342_("runner") : null;
        this.runnerId = nbt.m_128425_("runnerId", 3) ? nbt.m_128451_("runnerId") : -1;
        this.producibleEnergyQuantity = nbt.m_128454_("energy");
        this.runningTime = nbt.m_128451_("time");
    }

    protected void m_183515_(CompoundTag nbt) {
        Integer runnerId;
        UUID runnerUuid;
        super.m_183515_(nbt);
        Object object = this.runnerUUID == null ? (this.runner == null ? null : this.runner.m_20148_()) : (runnerUuid = this.runnerUUID);
        if (runnerUuid != null) {
            nbt.m_128362_("runner", runnerUuid);
        }
        Integer n = runnerId = this.runner == null ? null : Integer.valueOf(this.runner.m_19879_());
        if (runnerId != null) {
            nbt.m_128405_("runnerId", runnerId.intValue());
        }
        nbt.m_128356_("energy", this.producibleEnergyQuantity);
        nbt.m_128405_("time", this.runningTime);
    }

    private static Long getOutputEnergyQuantityForEntity(Entity entity, EnergyStorage energyStorage) {
        return ((EntityFitnessEvents.ModifyOutputEnergyQuantity)EntityFitnessEvents.MODIFY_OUTPUT_ENERGY_QUANTITY.invoker()).modifyOutputEnergyQuantity(entity, energyStorage, ENERGY_MAP.get(entity.m_6095_()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidEntity(Entity entity) {
        if (entity == null) return false;
        if (!entity.m_6084_()) {
            return false;
        }
        if (entity.m_5833_()) return false;
        if (entity.m_6144_()) return false;
        if (entity.m_6069_()) return false;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.f_20916_ > 0) return false;
            if (livingEntity.m_6162_()) return false;
        }
        if (entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            if (mobEntity.m_21523_()) return false;
        }
        if (!(entity instanceof TamableAnimal)) return true;
        TamableAnimal tameableEntity = (TamableAnimal)entity;
        if (tameableEntity.m_21827_()) return false;
        return true;
    }

    private static boolean isEntityNear(Entity entity, Vec3 pos) {
        return entity.m_20238_(pos) < 0.5;
    }

    private static Vec3 computeTreadmillPivot(BlockPos pos, Direction face) {
        double x = switch (face) {
            case Direction.WEST -> pos.m_123341_();
            case Direction.EAST -> pos.m_123341_() + 1;
            default -> (double)pos.m_123341_() + 0.5;
        };
        double y = (double)pos.m_123342_() + 0.175;
        double z = switch (face) {
            case Direction.SOUTH -> pos.m_123343_() + 1;
            case Direction.NORTH -> pos.m_123343_();
            default -> (double)pos.m_123343_() + 0.5;
        };
        return new Vec3(x, y, z);
    }

    static {
        EnergyStorage.SIDED.registerForBlockEntities((x, __) -> (EnergyStorage)x, new BlockEntityType[]{SyncBlockEntities.TREADMILL});
    }
}

