/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.gl;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL30;

@Environment(value=EnvType.CLIENT)
public class MSAAFramebuffer
extends RenderTarget {
    public static final int MIN_SAMPLES = 2;
    public static final int MAX_SAMPLES = GL30.glGetInteger((int)36183);
    private static final Map<Integer, MSAAFramebuffer> INSTANCES = new HashMap<Integer, MSAAFramebuffer>();
    private static final List<MSAAFramebuffer> ACTIVE_INSTANCES = new ArrayList<MSAAFramebuffer>();
    private static final ConcurrentMap<Integer, ConcurrentLinkedQueue<Runnable>> RENDER_CALLS = new ConcurrentHashMap<Integer, ConcurrentLinkedQueue<Runnable>>();
    private final int samples;
    private int rboColor;
    private int rboDepth;
    private boolean inUse;

    private MSAAFramebuffer(int samples) {
        super(true);
        if (samples < 2 || samples > MAX_SAMPLES) {
            throw new IllegalArgumentException(String.format("The number of samples should be >= %s and <= %s.", 2, MAX_SAMPLES));
        }
        if ((samples & samples - 1) != 0) {
            throw new IllegalArgumentException("The number of samples must be a power of two.");
        }
        this.samples = samples;
        this.m_83931_(1.0f, 1.0f, 1.0f, 0.0f);
    }

    private static MSAAFramebuffer getInstance(int samples) {
        return INSTANCES.computeIfAbsent(samples, x -> new MSAAFramebuffer(samples));
    }

    public static void use(int samples, Runnable drawAction) {
        MSAAFramebuffer.use(samples, Minecraft.m_91087_().m_91385_(), drawAction);
    }

    public static void use(int samples, RenderTarget mainBuffer, Runnable drawAction) {
        RenderSystem.assertOnRenderThreadOrInit();
        MSAAFramebuffer msaaBuffer = MSAAFramebuffer.getInstance(samples);
        msaaBuffer.m_83941_(mainBuffer.f_83915_, mainBuffer.f_83916_, true);
        GlStateManager._glBindFramebuffer((int)36008, (int)mainBuffer.f_83920_);
        GlStateManager._glBindFramebuffer((int)36009, (int)msaaBuffer.f_83920_);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)msaaBuffer.f_83915_, (int)msaaBuffer.f_83916_, (int)0, (int)0, (int)msaaBuffer.f_83915_, (int)msaaBuffer.f_83916_, (int)16384, (int)9729);
        msaaBuffer.m_83947_(true);
        drawAction.run();
        msaaBuffer.m_83970_();
        GlStateManager._glBindFramebuffer((int)36008, (int)msaaBuffer.f_83920_);
        GlStateManager._glBindFramebuffer((int)36009, (int)mainBuffer.f_83920_);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)msaaBuffer.f_83915_, (int)msaaBuffer.f_83916_, (int)0, (int)0, (int)msaaBuffer.f_83915_, (int)msaaBuffer.f_83916_, (int)16384, (int)9729);
        msaaBuffer.m_83954_(true);
        mainBuffer.m_83947_(false);
        MSAAFramebuffer.executeDelayedRenderCalls(samples);
    }

    public static void renderAfterUsage(int samples, Runnable renderCall) {
        if (MSAAFramebuffer.getInstance(samples).isInUse() || !RenderSystem.isOnRenderThreadOrInit()) {
            RENDER_CALLS.computeIfAbsent(samples, x -> Queues.newConcurrentLinkedQueue()).add(renderCall);
            return;
        }
        renderCall.run();
    }

    public static void renderAfterUsage(Runnable renderCall) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> MSAAFramebuffer.renderAfterUsage(renderCall));
        }
        if (ACTIVE_INSTANCES.size() != 0) {
            RENDER_CALLS.computeIfAbsent(MSAAFramebuffer.ACTIVE_INSTANCES.get((int)0).samples, x -> Queues.newConcurrentLinkedQueue()).add(renderCall);
            return;
        }
        renderCall.run();
    }

    private static void executeDelayedRenderCalls(int samples) {
        RenderSystem.assertOnRenderThreadOrInit();
        ConcurrentLinkedQueue<Runnable> queue = RENDER_CALLS.getOrDefault(samples, Queues.newConcurrentLinkedQueue());
        while (!queue.isEmpty()) {
            queue.poll().run();
        }
    }

    public void m_83941_(int width, int height, boolean getError) {
        if (this.f_83915_ != width || this.f_83916_ != height) {
            super.m_83941_(width, height, getError);
        }
    }

    public void m_83950_(int width, int height, boolean getError) {
        RenderSystem.assertOnRenderThreadOrInit();
        int maxSize = RenderSystem.maxSupportedTextureSize();
        if (width <= 0 || width > maxSize || height <= 0 || height > maxSize) {
            throw new IllegalArgumentException("Window " + width + "x" + height + " size out of bounds (max. size: " + maxSize + ")");
        }
        this.f_83917_ = width;
        this.f_83918_ = height;
        this.f_83915_ = width;
        this.f_83916_ = height;
        this.f_83920_ = GlStateManager.glGenFramebuffers();
        GlStateManager._glBindFramebuffer((int)36160, (int)this.f_83920_);
        this.rboColor = GlStateManager.glGenRenderbuffers();
        GlStateManager._glBindRenderbuffer((int)36161, (int)this.rboColor);
        GL30.glRenderbufferStorageMultisample((int)36161, (int)this.samples, (int)32856, (int)width, (int)height);
        GlStateManager._glBindRenderbuffer((int)36161, (int)0);
        this.rboDepth = GlStateManager.glGenRenderbuffers();
        GlStateManager._glBindRenderbuffer((int)36161, (int)this.rboDepth);
        GL30.glRenderbufferStorageMultisample((int)36161, (int)this.samples, (int)6402, (int)width, (int)height);
        GlStateManager._glBindRenderbuffer((int)36161, (int)0);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36064, (int)36161, (int)this.rboColor);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.rboDepth);
        this.f_83923_ = Minecraft.m_91087_().m_91385_().m_83975_();
        this.f_83924_ = Minecraft.m_91087_().m_91385_().m_83980_();
        this.m_83949_();
        this.m_83954_(getError);
        this.m_83963_();
    }

    public void m_83930_() {
        RenderSystem.assertOnRenderThreadOrInit();
        this.m_83963_();
        this.m_83970_();
        if (this.f_83920_ > -1) {
            GlStateManager._glBindFramebuffer((int)36160, (int)0);
            GlStateManager._glDeleteFramebuffers((int)this.f_83920_);
            this.f_83920_ = -1;
        }
        if (this.rboColor > -1) {
            GlStateManager._glDeleteRenderbuffers((int)this.rboColor);
            this.rboColor = -1;
        }
        if (this.rboDepth > -1) {
            GlStateManager._glDeleteRenderbuffers((int)this.rboDepth);
            this.rboDepth = -1;
        }
        this.f_83923_ = -1;
        this.f_83924_ = -1;
        this.f_83915_ = -1;
        this.f_83916_ = -1;
    }

    public void m_83947_(boolean setViewport) {
        super.m_83947_(setViewport);
        if (!this.inUse) {
            ACTIVE_INSTANCES.add(this);
            this.inUse = true;
        }
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void m_83970_() {
        super.m_83970_();
        if (this.inUse) {
            this.inUse = false;
            ACTIVE_INSTANCES.remove((Object)this);
        }
    }
}

