/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.gui;

import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.client.gl.MSAAFramebuffer;
import dev.kir.sync.client.gui.TooltipProvider;
import dev.kir.sync.client.gui.controller.HudController;
import dev.kir.sync.client.gui.widget.ArrowButtonWidget;
import dev.kir.sync.client.gui.widget.CrossButtonWidget;
import dev.kir.sync.client.gui.widget.PageDisplayWidget;
import dev.kir.sync.client.gui.widget.ShellSelectorButtonWidget;
import dev.kir.sync.util.IdentifierUtil;
import dev.kir.sync.util.client.render.ColorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

@Environment(value=EnvType.CLIENT)
public class ShellSelectorGUI
extends Screen {
    private static final int MAX_SLOTS = 8;
    private static final double MENU_RADIUS = (double)0.3f;
    private static final int BACKGROUND_COLOR = ColorUtil.fromDyeColor(DyeColor.BLACK, 0.3f);
    private static final Component TITLE = Component.m_237115_((String)"gui.sync.default.cross_button.title");
    private static final Collection<Component> ARROW_TITLES = List.of(Component.m_237115_((String)"gui.sync.shell_selector.up.title"), Component.m_237115_((String)"gui.sync.shell_selector.right.title"), Component.m_237115_((String)"gui.sync.shell_selector.down.title"), Component.m_237115_((String)"gui.sync.shell_selector.left.title"));
    private final Runnable onCloseCallback;
    private final Runnable onRemovedCallback;
    private boolean wasClosed;
    private List<ShellSelectorButtonWidget> shellButtons;
    private List<ArrowButtonWidget> arrowButtons;
    private CrossButtonWidget crossButton;
    private PageDisplayWidget<ResourceLocation, ShellState> pageDisplay;

    public ShellSelectorGUI(Runnable onCloseCallback, Runnable onRemovedCallback) {
        super(TITLE);
        this.onCloseCallback = onCloseCallback;
        this.onRemovedCallback = onRemovedCallback;
    }

    public void m_7856_() {
        LocalPlayer player = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        Stream<ShellState> data = ((Shell)player).getAvailableShellStates();
        ResourceLocation selectedWorld = player.m_9236_().m_46472_().m_135782_();
        this.wasClosed = false;
        this.arrowButtons = ShellSelectorGUI.createArrowButtons(this.f_96543_, this.f_96544_, ARROW_TITLES, List.of(this::previousSection, this::nextPage, this::nextSection, this::previousPage));
        this.crossButton = ShellSelectorGUI.createCrossButton(this.f_96543_, this.f_96544_, this::m_7379_);
        this.pageDisplay = ShellSelectorGUI.createPageDisplay(this.f_96543_, this.f_96544_, data, selectedWorld, 8, this::onPageChange);
        Stream.concat(this.arrowButtons.stream(), Stream.of(this.crossButton, this.pageDisplay)).forEach(x$0 -> {
            NarratableEntry cfr_ignored_0 = (NarratableEntry)this.m_142416_((GuiEventListener)x$0);
        });
        HudController.hide();
    }

    private static List<ShellSelectorButtonWidget> createShellButtons(int screenWidth, int screenHeight, int count) {
        double HOLLOW_R = 0.18f;
        double BORDER_WIDTH = 0.0033;
        double SECTOR_SPACING = 0.01;
        double cX = (double)screenWidth / 2.0;
        double cY = (double)screenHeight / 2.0;
        double majorR = (double)screenHeight * (double)0.3f;
        double minorR = (double)screenHeight * (double)0.18f;
        double spacing = count > 1 ? 0.01 : 0.0;
        double sector = (double)((float)Math.PI * 2 / (float)count) - spacing;
        double borderWidth = (double)screenHeight * 0.0033;
        double pos = -sector / (double)(2 << count % 2);
        ArrayList<ShellSelectorButtonWidget> shellButtons = new ArrayList<ShellSelectorButtonWidget>();
        for (int i = 0; i < count; ++i) {
            ShellSelectorButtonWidget button = new ShellSelectorButtonWidget(cX, cY, majorR, minorR, borderWidth, pos, pos + sector);
            pos += sector + spacing;
            shellButtons.add(button);
        }
        return shellButtons;
    }

    private static PageDisplayWidget<ResourceLocation, ShellState> createPageDisplay(int screenWidth, int screenHeight, Stream<ShellState> data, ResourceLocation defaultPage, int entriesPerPage, BiConsumer<PageDisplayWidget<ResourceLocation, ShellState>, PageDisplayWidget.Page> onChange) {
        float FONT_HEIGHT = 0.033333335f;
        float cX = (float)screenWidth / 2.0f;
        float cY = (float)screenHeight / 2.0f;
        float f = (float)screenHeight * 0.033333335f;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        float scale = f / 9.0f;
        return new PageDisplayWidget<ResourceLocation, ShellState>(cX, cY, scale, data, ShellState::getWorld, IdentifierUtil::prettifyAsText, defaultPage, entriesPerPage, onChange);
    }

    private static List<ArrowButtonWidget> createArrowButtons(int screenWidth, int screenHeight, Iterable<Component> arrowTitles, Iterable<Runnable> arrowActions) {
        float ARROW_HEIGHT = 0.026666667f;
        float ARROW_WIDTH = 1.78125f;
        float ARROW_THICKNESS = 0.004166667f;
        float ARROW_SPACING = 0.071428575f;
        float cX = (float)screenWidth / 2.0f;
        float cY = (float)screenHeight / 2.0f;
        float r = (float)screenHeight * 0.3f * 1.0714285f;
        float arrowHeight = (float)screenHeight * 0.026666667f;
        float arrowWidth = arrowHeight * 1.78125f;
        float thickness = (float)screenHeight * 0.004166667f;
        Iterator<Runnable> actions = arrowActions.iterator();
        Iterator<Component> descriptions = arrowTitles.iterator();
        ArrayList<ArrowButtonWidget> arrowButtons = new ArrayList<ArrowButtonWidget>();
        for (ArrowButtonWidget.ArrowType arrowType : ArrowButtonWidget.ArrowType.values()) {
            float y;
            float x;
            if (arrowType.isVertical()) {
                x = (float)screenWidth / 2.0f - arrowWidth / 2.0f;
                y = cY + r * (float)(arrowType.isDown() ? 1 : -1) + (arrowType.isDown() ? 0.0f : -arrowHeight);
            } else {
                x = cX + r * (float)(arrowType.isRight() ? 1 : -1) + (arrowType.isRight() ? 0.0f : -arrowHeight);
                y = (float)screenHeight / 2.0f - arrowWidth / 2.0f;
            }
            arrowButtons.add(new ArrowButtonWidget(x, y, arrowWidth, arrowHeight, arrowType, thickness, descriptions.next(), actions.next()));
        }
        return arrowButtons;
    }

    private static CrossButtonWidget createCrossButton(int screenWidth, int screenHeight, Runnable onClose) {
        float CROSS_MARGIN = 0.06666667f;
        float CROSS_WIDTH = 0.026666667f;
        float CROSS_THICKNESS = 0.004166667f;
        float width = (float)screenHeight * 0.026666667f;
        float y = (float)screenHeight * 0.06666667f;
        float x = (float)screenWidth - y - width;
        float thickness = (float)screenHeight * 0.004166667f;
        return new CrossButtonWidget(x, y, width, width, thickness, onClose);
    }

    public void m_280273_(GuiGraphics drawContext) {
        if (Objects.requireNonNull(this.f_96541_).f_91073_ != null) {
            drawContext.m_280024_(0, 0, this.f_96543_, this.f_96544_, BACKGROUND_COLOR, BACKGROUND_COLOR);
        } else {
            super.m_280273_(drawContext);
        }
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.m_280273_(drawContext);
        MSAAFramebuffer.use(MSAAFramebuffer.MAX_SAMPLES, () -> super.m_88315_(drawContext, mouseX, mouseY, delta));
        this.renderTooltips(drawContext, mouseX, mouseY);
    }

    protected void renderTooltips(GuiGraphics drawContext, int mouseX, int mouseY) {
        for (GuiEventListener child : this.m_6702_()) {
            Component tooltipText;
            NarratableEntry selectable;
            if (!(child instanceof NarratableEntry) || (selectable = (NarratableEntry)child).m_142684_() == NarratableEntry.NarrationPriority.NONE) continue;
            if (selectable instanceof TooltipProvider) {
                TooltipProvider tooltipProvider = (TooltipProvider)selectable;
                v0 = tooltipProvider.getTooltip();
            } else {
                v0 = tooltipText = null;
            }
            if (tooltipText != null) {
                drawContext.m_280557_(this.f_96547_, tooltipText, mouseX, mouseY);
            }
            return;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6913_() {
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    private void onPageChange(PageDisplayWidget<ResourceLocation, ShellState> pageDisplay, PageDisplayWidget.Page page) {
        for (ArrowButtonWidget arrow : this.arrowButtons) {
            arrow.f_93624_ = arrow.type.isVertical() ? pageDisplay.hasMoreSections() : pageDisplay.hasMorePages();
        }
        if (this.shellButtons != null) {
            this.shellButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        }
        List content = page.content;
        this.shellButtons = ShellSelectorGUI.createShellButtons(this.f_96543_, this.f_96544_, Math.max(content.size(), 1));
        this.shellButtons.forEach(x$0 -> {
            ShellSelectorButtonWidget cfr_ignored_0 = (ShellSelectorButtonWidget)this.m_142416_((GuiEventListener)x$0);
        });
        for (int i = 0; i < content.size(); ++i) {
            this.shellButtons.get((int)i).shell = (ShellState)content.get(i);
        }
    }

    private void nextSection() {
        this.pageDisplay.nextSection();
    }

    private void previousSection() {
        this.pageDisplay.previousSection();
    }

    private void nextPage() {
        this.pageDisplay.nextPage();
    }

    private void previousPage() {
        this.pageDisplay.previousPage();
    }

    public void m_7379_() {
        HudController.restore();
        if (this.onCloseCallback != null) {
            this.onCloseCallback.run();
        }
        this.wasClosed = true;
        super.m_7379_();
    }

    public void m_7861_() {
        super.m_7861_();
        if (!this.wasClosed && this.onRemovedCallback != null) {
            this.onRemovedCallback.run();
        }
    }
}

