/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.gui.widget;

import dev.kir.sync.client.gui.TooltipProvider;
import java.util.Date;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractWidget
implements Renderable,
NarratableEntry,
TooltipProvider,
GuiEventListener {
    public boolean visible = true;
    private boolean isHovered = false;
    private boolean isPressed = false;
    private double lastMouseX = -1.0;
    private double lastMouseY = -1.0;
    private long lastMovementTime = 0L;

    public boolean isHovered() {
        return this.isHovered;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.visible) {
            this.m_94757_(mouseX, mouseY);
            this.renderContent(drawContext, mouseX, mouseY, delta);
        }
    }

    protected abstract void renderContent(GuiGraphics var1, int var2, int var3, float var4);

    public void m_94757_(double mouseX, double mouseY) {
        this.isHovered = this.visible && this.m_5953_(mouseX, mouseY);
        this.isPressed &= this.isHovered;
        if (!this.isHovered || this.lastMouseX != mouseX || this.lastMouseY != mouseY) {
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.lastMovementTime = new Date().getTime();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.visible && this.isHovered) {
            this.isPressed = true;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.visible && this.isPressed) {
            this.onMouseClick(mouseX, mouseY, button);
            this.isPressed = false;
            return true;
        }
        return false;
    }

    protected void onMouseClick(double mouseX, double mouseY, int button) {
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return this.isPressed() ? NarratableEntry.NarrationPriority.FOCUSED : (this.isHovered() ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE);
    }

    @Override
    public Component getTooltip() {
        if (this.isHovered && new Date().getTime() - this.lastMovementTime >= this.getTooltipDelay()) {
            return this.getWidgetDescription();
        }
        return null;
    }

    protected long getTooltipDelay() {
        return 500L;
    }

    protected Component getWidgetDescription() {
        return null;
    }

    public void m_142291_(NarrationElementOutput builder) {
        Component description = this.getWidgetDescription();
        if (description != null) {
            builder.m_169146_(NarratedElementType.TITLE, description);
        }
    }
}

