/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.kir.sync.util.client.render.ColorUtil;
import dev.kir.sync.util.client.render.RenderSystemUtil;
import dev.kir.sync.util.math.QuarticFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

@Environment(value=EnvType.CLIENT)
public class ArrowButtonWidget
extends Button {
    private static final Component DEFAULT_DESCRIPTION = null;
    private static final int DEFAULT_COLOR = ColorUtil.fromDyeColor(DyeColor.WHITE);
    private static final float DEFAULT_STEP = 0.09817477f;
    public final ArrowType type;
    private final float step;
    private final float[] color;
    private final Component description;
    private final float x0;
    private final float y0;
    private final float x1;
    private final float y1;
    private final float borderRadius;
    private final float stickWidth;
    private final float stickHeight;
    private final float angle;

    public ArrowButtonWidget(float x, float y, float width, float height, ArrowType type, float thickness, Runnable onClick) {
        this(x, y, width, height, type, thickness, 0.09817477f, DEFAULT_COLOR, DEFAULT_DESCRIPTION, onClick);
    }

    public ArrowButtonWidget(float x, float y, float width, float height, ArrowType type, float thickness, Component description, Runnable onClick) {
        this(x, y, width, height, type, thickness, 0.09817477f, DEFAULT_COLOR, description, onClick);
    }

    public ArrowButtonWidget(float x, float y, float width, float height, ArrowType type, float thickness, int color, Runnable onClick) {
        this(x, y, width, height, type, thickness, 0.09817477f, color, DEFAULT_DESCRIPTION, onClick);
    }

    public ArrowButtonWidget(float x, float y, float width, float height, ArrowType type, float thickness, int color, Component description, Runnable onClick) {
        this(x, y, width, height, type, thickness, 0.09817477f, color, description, onClick);
    }

    public ArrowButtonWidget(float x, float y, float width, float height, ArrowType type, float thickness, float step, int color, Component description, Runnable onClick) {
        super((int)x, (int)y, (int)(type.isVertical() ? width : height), (int)(type.isVertical() ? height : width), description, button -> onClick.run(), textSupplier -> Component.m_237119_());
        this.type = type;
        this.step = step;
        this.color = ColorUtil.toRGBA(color);
        this.description = description;
        float shiftY = (float)new QuarticFunction(1.0, -2.0f * height, height * height + width * width / 4.0f, 0.0, -width * width / 4.0f * thickness * thickness).getRoot(1);
        this.angle = (float)Math.acos(shiftY / thickness);
        this.x0 = x;
        this.y0 = y + height - shiftY;
        this.x1 = x + width / 2.0f;
        this.y1 = y;
        this.borderRadius = thickness * 0.5f;
        this.stickHeight = thickness;
        this.stickWidth = Mth.m_14116_((float)(Mth.m_14207_((float)(width / 2.0f)) + Mth.m_14207_((float)(height - shiftY))));
    }

    protected void m_87963_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        drawContext.m_280168_().m_85836_();
        this.type.transform(drawContext.m_280168_(), this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        RenderSystemUtil.drawRectangle(drawContext.m_280168_(), this.x0, this.y0, this.stickWidth, this.stickHeight, this.borderRadius, 1.0f, -this.angle, this.step, this.color[0], this.color[1], this.color[2], this.color[3]);
        RenderSystemUtil.drawRectangle(drawContext.m_280168_(), this.x1, this.y1, this.stickWidth, this.stickHeight, this.borderRadius, 1.0f, this.angle, this.step, this.color[0], this.color[1], this.color[2], this.color[3]);
        drawContext.m_280168_().m_85849_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_93624_ && this.type.isValidKey(keyCode)) {
            this.m_6375_(0.0, 0.0, 0);
            return true;
        }
        return false;
    }

    public static enum ArrowType {
        UP(0, 265, 266, 87),
        RIGHT(1, 262, 68),
        DOWN(2, 264, 267, 83),
        LEFT(3, 263, 65);

        private final int i;
        private final int[] keyCodes;

        private ArrowType(int i, int ... keyCodes) {
            this.i = i;
            this.keyCodes = keyCodes;
        }

        public boolean isValidKey(int keyCode) {
            for (int code : this.keyCodes) {
                if (code != keyCode) continue;
                return true;
            }
            return false;
        }

        public boolean isUp() {
            return this == UP;
        }

        public boolean isRight() {
            return this == RIGHT;
        }

        public boolean isLeft() {
            return this == LEFT;
        }

        public boolean isDown() {
            return this == DOWN;
        }

        public boolean isVertical() {
            return this == UP || this == DOWN;
        }

        public boolean isHorizontal() {
            return this == LEFT || this == RIGHT;
        }

        public void transform(PoseStack matrices, float x, float y, float width, float height) {
            if (this.isHorizontal()) {
                float tmp = width;
                width = height;
                height = tmp;
            }
            matrices.m_252880_(x, y, 0.0f);
            matrices.m_252781_(Axis.f_252403_.m_252961_(1.5707964f * (float)this.i));
            matrices.m_252880_(-x - (this.i == 2 || this.i == 3 ? width : 0.0f), -y - (this.i == 1 || this.i == 2 ? height : 0.0f), 0.0f);
        }
    }
}

