/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.gui.widget;

import dev.kir.sync.client.gui.widget.AbstractButtonWidget;
import dev.kir.sync.util.client.render.ColorUtil;
import dev.kir.sync.util.client.render.RenderSystemUtil;
import dev.kir.sync.util.math.QuarticFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

@Environment(value=EnvType.CLIENT)
public class CrossButtonWidget
extends AbstractButtonWidget {
    private static final Component DEFAULT_DESCRIPTION = Component.m_237115_((String)"gui.sync.default.cross_button.title");
    private static final int DEFAULT_COLOR = ColorUtil.fromDyeColor(DyeColor.WHITE);
    private static final float DEFAULT_STEP = 0.09817477f;
    private final float step;
    private final float[] color;
    private final Component description;
    private final float x0;
    private final float y0;
    private final float x1;
    private final float y1;
    private final float borderRadius;
    private final float stickWidth;
    private final float stickHeight;
    private final float angle;
    private boolean focused;

    public CrossButtonWidget(float x, float y, float width, float height, float thickness, Runnable onClick) {
        this(x, y, width, height, thickness, 0.09817477f, DEFAULT_COLOR, DEFAULT_DESCRIPTION, onClick);
    }

    public CrossButtonWidget(float x, float y, float width, float height, float thickness, int color, Runnable onClick) {
        this(x, y, width, height, thickness, 0.09817477f, color, DEFAULT_DESCRIPTION, onClick);
    }

    public CrossButtonWidget(float x, float y, float width, float height, float thickness, Component description, Runnable onClick) {
        this(x, y, width, height, thickness, 0.09817477f, DEFAULT_COLOR, description, onClick);
    }

    public CrossButtonWidget(float x, float y, float width, float height, float thickness, int color, Component description, Runnable onClick) {
        this(x, y, width, height, thickness, 0.09817477f, color, description, onClick);
    }

    public CrossButtonWidget(float x, float y, float width, float height, float thickness, float step, int color, Component description, Runnable onClick) {
        super(x, y, width, height, onClick);
        this.step = step;
        this.color = ColorUtil.toRGBA(color);
        this.description = description;
        float shiftY = (float)new QuarticFunction(4.0, -4.0f * height, height * height + width * width - 4.0f * thickness * thickness, 2.0f * height * thickness * thickness, thickness * thickness * (thickness * thickness - width * width)).getRoot(1);
        float shiftX = (float)Math.sqrt(thickness * thickness - shiftY * shiftY);
        this.angle = (float)Math.acos(shiftY / thickness);
        this.x0 = x;
        this.y0 = y + height - shiftY;
        this.x1 = x + shiftX;
        this.y1 = y;
        this.borderRadius = thickness * 0.5f;
        this.stickHeight = thickness;
        this.stickWidth = Mth.m_14116_((float)(Mth.m_14207_((float)(width - shiftX)) + Mth.m_14207_((float)(height - shiftY))));
    }

    @Override
    protected void renderContent(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        RenderSystemUtil.drawRectangle(drawContext.m_280168_(), this.x0, this.y0, this.stickWidth, this.stickHeight, this.borderRadius, 1.0f, -this.angle, this.step, this.color[0], this.color[1], this.color[2], this.color[3]);
        RenderSystemUtil.drawRectangle(drawContext.m_280168_(), this.x1, this.y1, this.stickWidth, this.stickHeight, this.borderRadius, 1.0f, this.angle, this.step, this.color[0], this.color[1], this.color[2], this.color[3]);
    }

    @Override
    protected Component getWidgetDescription() {
        return this.description;
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public boolean m_93696_() {
        return this.focused;
    }
}

