/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.DoubleBlockCombiner;

@Environment(value=EnvType.CLIENT)
public abstract class DoubleBlockModel
extends Model {
    private final Map<DoubleBlockCombiner.BlockType, List<ModelPart>> parts;
    protected final int textureWidth;
    protected final int textureHeight;

    public DoubleBlockModel(int textureWidth, int textureHeight) {
        this(RenderType::m_110452_, textureWidth, textureHeight);
    }

    public DoubleBlockModel(Function<ResourceLocation, RenderType> layerFactory, int textureWidth, int textureHeight) {
        super(layerFactory);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.parts = new HashMap<DoubleBlockCombiner.BlockType, List<ModelPart>>();
    }

    protected ModelPart createCuboid(int textureOffsetU, int textureOffsetV, float x, float y, float z, float xSize, float ySize, float zSize) {
        ModelPart.Cube cuboid = new ModelPart.Cube(textureOffsetU, textureOffsetV, 0.0f, 0.0f, 0.0f, xSize, ySize, zSize, 0.0f, 0.0f, 0.0f, true, (float)this.textureWidth, (float)this.textureHeight, Arrays.stream(Direction.values()).collect(Collectors.toSet()));
        ModelPart part = new ModelPart(List.of(cuboid), Map.of());
        part.m_104227_(x, y, z);
        return part;
    }

    protected ModelPart createCuboid(int textureOffsetU, int textureOffsetV, float x, float y, float z, float xSize, float ySize, float zSize, ModelPart template) {
        ModelPart part = this.createCuboid(textureOffsetU, textureOffsetV, x, y, z, xSize, ySize, zSize);
        part.m_104315_(template);
        part.m_104227_(x, y, z);
        return part;
    }

    protected ModelPart addCuboid(DoubleBlockCombiner.BlockType type, int textureOffsetU, int textureOffsetV, float x, float y, float z, float xSize, float ySize, float zSize) {
        ModelPart part = this.createCuboid(textureOffsetU, textureOffsetV, x, y, z, xSize, ySize, zSize);
        if (!this.parts.containsKey(type)) {
            this.parts.put(type, new ArrayList());
        }
        this.parts.get(type).add(part);
        return part;
    }

    protected ModelPart addCuboid(DoubleBlockCombiner.BlockType type, int textureOffsetU, int textureOffsetV, float x, float y, float z, float xSize, float ySize, float zSize, ModelPart template) {
        ModelPart part = this.addCuboid(type, textureOffsetU, textureOffsetV, x, y, z, xSize, ySize, zSize);
        part.m_104315_(template);
        part.m_104227_(x, y, z);
        return part;
    }

    protected ModelPart createTemplate() {
        return new ModelPart(List.of(), Map.of());
    }

    protected ModelPart createRotationTemplate(float pitch, float yaw, float roll) {
        ModelPart template = this.createTemplate();
        template.f_104203_ = pitch;
        template.f_104204_ = yaw;
        template.f_104205_ = roll;
        return template;
    }

    public void render(PoseStack matrices, VertexConsumer vertices, int light, int overlay) {
        this.m_7695_(matrices, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        matrices.m_85836_();
        this.render(DoubleBlockCombiner.BlockType.FIRST, matrices, vertices, light, overlay, red, green, blue, alpha);
        this.translate(matrices);
        this.render(DoubleBlockCombiner.BlockType.SECOND, matrices, vertices, light, overlay, red, green, blue, alpha);
        matrices.m_85849_();
    }

    public void render(DoubleBlockCombiner.BlockType type, PoseStack matrices, VertexConsumer vertices, int light, int overlay) {
        this.render(type, matrices, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(DoubleBlockCombiner.BlockType type, PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        List<ModelPart> currentParts = this.parts.get(type);
        if (currentParts == null) {
            return;
        }
        for (ModelPart part : currentParts) {
            part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    protected abstract void translate(PoseStack var1);
}

