/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.kir.sync.client.model.AbstractShellContainerModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.level.block.DoubleBlockCombiner;

@Environment(value=EnvType.CLIENT)
public class ShellConstructorModel
extends AbstractShellContainerModel {
    public final ModelPart floor;
    public final ModelPart floorRimF;
    public final ModelPart floorRimL;
    public final ModelPart floorRimR;
    public final ModelPart floorRimB;
    public final ModelPart ceiling;
    public final ModelPart ceilingRimF;
    public final ModelPart ceilingRimL;
    public final ModelPart ceilingRimR;
    public final ModelPart ceilingRimB;
    public final ModelPart wallLL;
    public final ModelPart wallLU;
    public final ModelPart wallRL;
    public final ModelPart wallRU;
    public final ModelPart wallBL;
    public final ModelPart wallBU;
    public final ModelPart pillarBLU;
    public final ModelPart pillarBLL;
    public final ModelPart pillarBRU;
    public final ModelPart pillarBRL;
    public final ModelPart pillarFLU;
    public final ModelPart pillarFLL;
    public final ModelPart pillarFRU;
    public final ModelPart pillarFRL;
    public final ModelPart sprayerR;
    public final ModelPart sprayerG;
    public final ModelPart sprayerB;
    public final ModelPart sprayerRMast;
    public final ModelPart sprayerGMast;
    public final ModelPart sprayerBMast;
    public final ModelPart printerL;
    public final ModelPart printerR;
    public float buildProgress;
    public boolean showInnerParts;

    public ShellConstructorModel() {
        ModelPart rightPart = this.createRotationTemplate(0.0f, 0.7853982f, 0.0f);
        ModelPart leftPart = this.createRotationTemplate(0.0f, -0.7853982f, 0.0f);
        this.floor = this.addCuboid(BOTTOM, 64, 62, -16.0f, 23.0f, -16.0f, 32.0f, 1.0f, 32.0f);
        this.floorRimF = this.addCuboid(BOTTOM, 70, 34, -13.0f, 22.0f, -14.0f, 26.0f, 1.0f, 3.0f);
        this.floorRimL = this.addCuboid(BOTTOM, 0, 38, 13.0f, 22.0f, -14.0f, 3.0f, 1.0f, 27.0f);
        this.floorRimR = this.addCuboid(BOTTOM, 0, 38, -16.0f, 22.0f, -14.0f, 3.0f, 1.0f, 27.0f);
        this.floorRimB = this.addCuboid(BOTTOM, 0, 34, -16.0f, 22.0f, 13.0f, 32.0f, 1.0f, 3.0f);
        this.ceiling = this.addCuboid(TOP, 0, 0, -16.0f, -8.0f, -16.0f, 32.0f, 2.0f, 32.0f);
        this.ceilingRimF = this.addCuboid(TOP, 70, 34, -13.0f, -6.0f, -14.0f, 26.0f, 1.0f, 3.0f);
        this.ceilingRimL = this.addCuboid(TOP, 0, 38, 13.0f, -6.0f, -14.0f, 3.0f, 1.0f, 27.0f);
        this.ceilingRimR = this.addCuboid(TOP, 0, 38, -16.0f, -6.0f, -14.0f, 3.0f, 1.0f, 27.0f);
        this.ceilingRimB = this.addCuboid(TOP, 0, 34, -16.0f, -6.0f, 13.0f, 32.0f, 1.0f, 3.0f);
        this.wallLL = this.addCuboid(BOTTOM, 200, 122, 15.05f, -8.0f, -14.0f, 1.0f, 30.0f, 27.0f);
        this.wallLU = this.addCuboid(TOP, 200, 66, 15.05f, -5.0f, -14.0f, 1.0f, 29.0f, 27.0f);
        this.wallRL = this.addCuboid(BOTTOM, 200, 122, -16.05f, -8.0f, -14.0f, 1.0f, 30.0f, 27.0f);
        this.wallRU = this.addCuboid(TOP, 200, 66, -16.05f, -5.0f, -14.0f, 1.0f, 29.0f, 27.0f);
        this.wallBL = this.addCuboid(BOTTOM, 101, 188, -13.0f, -8.0f, 14.0f, 26.0f, 30.0f, 1.0f);
        this.wallBU = this.addCuboid(TOP, 101, 156, -13.0f, -5.0f, 14.0f, 26.0f, 29.0f, 1.0f);
        this.pillarFLL = this.addCuboid(BOTTOM, 60, 68, -16.0f, -8.0f, -15.0f, 1.0f, 31.0f, 1.0f);
        this.pillarFLU = this.addCuboid(TOP, 60, 38, -16.0f, -6.0f, -15.0f, 1.0f, 30.0f, 1.0f);
        this.pillarFRL = this.addCuboid(BOTTOM, 60, 68, 15.0f, -8.0f, -15.0f, 1.0f, 31.0f, 1.0f);
        this.pillarFRU = this.addCuboid(TOP, 60, 38, 15.0f, -6.0f, -15.0f, 1.0f, 30.0f, 1.0f);
        this.pillarBLL = this.addCuboid(BOTTOM, 0, 155, -16.0f, -8.0f, 13.0f, 3.0f, 30.0f, 3.0f);
        this.pillarBLU = this.addCuboid(TOP, 0, 126, -16.0f, -5.0f, 13.0f, 3.0f, 29.0f, 3.0f);
        this.pillarBRL = this.addCuboid(BOTTOM, 0, 155, 13.0f, -8.0f, 13.0f, 3.0f, 30.0f, 3.0f);
        this.pillarBRU = this.addCuboid(TOP, 0, 126, 13.0f, -5.0f, 13.0f, 3.0f, 29.0f, 3.0f);
        this.sprayerR = this.createCuboid(132, 0, -12.0f, -9.0f, -9.55f, 2.0f, 1.0f, 2.0f, rightPart);
        this.sprayerG = this.createCuboid(132, 0, 10.0f, -9.0f, -9.55f, 2.0f, 1.0f, 2.0f, leftPart);
        this.sprayerB = this.createCuboid(132, 0, -1.0f, -9.0f, 10.55f, 2.0f, 1.0f, 2.0f);
        this.sprayerRMast = this.createCuboid(128, 0, -11.5f, -8.5f, -9.5f, 1.0f, 32.0f, 1.0f, rightPart);
        this.sprayerGMast = this.createCuboid(128, 0, 10.5f, -8.5f, -9.5f, 1.0f, 32.0f, 1.0f, leftPart);
        this.sprayerBMast = this.createCuboid(128, 0, -0.5f, -8.5f, 11.5f, 1.0f, 32.0f, 1.0f);
        this.printerL = this.createCuboid(54, 66, 13.0f, 20.0f, 12.0f, 1.0f, 2.0f, 2.0f, leftPart);
        this.printerR = this.createCuboid(54, 66, -14.0f, 20.0f, 12.0f, 1.0f, 2.0f, 2.0f, rightPart);
    }

    @Override
    public void render(DoubleBlockCombiner.BlockType type, PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        super.render(type, matrices, vertices, light, overlay, red, green, blue, alpha);
        if (type != BOTTOM || !this.showInnerParts) {
            return;
        }
        float MIN_SPRAYER_Y = 22.0f;
        float SPRAYER_HEIGHT = -60.0f;
        float MIN_PRINTER_Y = 20.0f;
        float PRINTER_HEIGHT = -58.0f;
        float MAST_HEIGHT = 32.0f;
        float MAST_Y = -10.0f;
        float SPRAYER_ACTIVATION_STAGE = 0.9f;
        float printingProgress = this.buildProgress / 0.75f;
        float paintingProgress = (this.buildProgress - 0.75f) / 0.25f;
        float printerY = 20.0f + -58.0f * (printingProgress <= 1.0f ? printingProgress : 1.0f - paintingProgress);
        float sprayerY = 22.0f + -60.0f * (printingProgress < 0.9f ? 0.0f : (printingProgress <= 1.0f ? (printingProgress - 0.9f) / 0.100000024f : 1.0f - paintingProgress));
        this.renderPrinter(printerY, matrices, vertices, light, overlay, red, green, blue, alpha);
        this.renderSprayer(sprayerY, true, matrices, vertices, light, overlay, red, green, blue, alpha);
        if (sprayerY < -10.0f) {
            this.renderSprayer(-10.0f, false, matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    private void renderSprayer(float y, boolean isFullyVisible, PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.sprayerRMast.f_104201_ = y;
        this.sprayerGMast.f_104201_ = y;
        this.sprayerBMast.f_104201_ = y;
        this.sprayerRMast.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.sprayerGMast.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.sprayerBMast.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        if (!isFullyVisible) {
            return;
        }
        this.sprayerR.f_104201_ = y -= 0.5f;
        this.sprayerG.f_104201_ = y;
        this.sprayerB.f_104201_ = y;
        this.sprayerR.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.sprayerG.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.sprayerB.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    private void renderPrinter(float y, PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.printerL.f_104201_ = y;
        this.printerR.f_104201_ = y;
        this.printerL.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
        this.printerR.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
    }
}

