/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.kir.sync.client.model.VoxelModel;
import dev.kir.sync.client.render.CustomRenderLayer;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public class ShellModel<T extends AgeableListModel<?>>
extends Model {
    public final T parentModel;
    private float buildProgress;
    private final VoxelModel voxelModel;

    public ShellModel(T parentModel) {
        this(parentModel, new Random());
    }

    public ShellModel(T parentModel, Random random) {
        super(null);
        this.parentModel = parentModel;
        this.buildProgress = 0.0f;
        this.voxelModel = VoxelModel.fromModel(parentModel, random);
    }

    public void setBuildProgress(float buildProgress) {
        this.buildProgress = buildProgress;
        this.voxelModel.completeness = buildProgress / 0.75f;
    }

    public void setDestructionProgress(float destructionProgress) {
        this.voxelModel.destructionProgress = destructionProgress;
    }

    public RenderType m_103119_(ResourceLocation textureId) {
        if (this.isBeingPrinted() || this.isBeingDestroyed()) {
            return this.voxelModel.m_103119_(textureId);
        }
        if (this.isBeingPainted()) {
            float paintingProgress = (this.buildProgress - 0.75f) / 0.25f;
            float cutoutY = this.voxelModel.pivotY + this.voxelModel.sizeY * (1.0f - paintingProgress);
            return CustomRenderLayer.getEntityTranslucentPartiallyTextured(textureId, cutoutY);
        }
        return RenderType.m_110473_((ResourceLocation)textureId);
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        VoxelModel target = this.isBeingPrinted() || this.isBeingDestroyed() ? this.voxelModel : this.parentModel;
        target.m_7695_(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    private boolean isBeingPrinted() {
        return this.buildProgress >= 0.0f && this.buildProgress < 0.75f;
    }

    private boolean isBeingPainted() {
        return this.buildProgress >= 0.75f && this.buildProgress < 1.0f;
    }

    private boolean isBeingDestroyed() {
        return this.voxelModel.destructionProgress > 0.0f;
    }
}

