/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.render;

import com.mojang.blaze3d.vertex.VertexFormat;
import dev.kir.sync.client.render.CustomGameRenderer;
import dev.kir.sync.client.render.CustomVertexFormats;
import dev.kir.sync.client.render.MatrixStackStorage;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public final class CustomRenderLayer
extends RenderType {
    private static final RenderType VOXELS = CustomGameRenderer.getRenderTypeVoxelShader().getRenderLayer((RenderType)CustomRenderLayer.m_173215_((String)"voxels", (VertexFormat)CustomVertexFormats.POSITION_COLOR_OVERLAY_LIGHT_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173105_).m_110685_(f_110134_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true)));
    private static final BiFunction<ResourceLocation, Boolean, RenderType> ENTITY_TRANSLUCENT_PARTIALLY_TEXTURED = Util.m_143821_((id, outline) -> CustomGameRenderer.getRenderTypeEntityTranslucentPartiallyTexturedShader().getRenderLayer(RenderType.m_110454_((ResourceLocation)id, (boolean)outline)));

    private CustomRenderLayer(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static RenderType getVoxels() {
        return VOXELS;
    }

    public static RenderType getEntityTranslucentPartiallyTextured(ResourceLocation textureId, float cutoutY) {
        return CustomRenderLayer.getEntityTranslucentPartiallyTextured(textureId, cutoutY, true);
    }

    public static RenderType getEntityTranslucentPartiallyTextured(ResourceLocation textureId, float cutoutY, boolean affectsOutline) {
        CustomGameRenderer.initRenderTypeEntityTranslucentPartiallyTexturedShader(cutoutY, MatrixStackStorage.getModelMatrixStack().m_85850_().m_252922_());
        return ENTITY_TRANSLUCENT_PARTIALLY_TEXTURED.apply(textureId, affectsOutline);
    }
}

