/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.render;

import dev.kir.sync.block.entity.SyncBlockEntities;
import dev.kir.sync.client.render.block.entity.ShellConstructorBlockEntityRenderer;
import dev.kir.sync.client.render.block.entity.ShellStorageBlockEntityRenderer;
import dev.kir.sync.client.render.block.entity.TreadmillBlockEntityRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

@Environment(value=EnvType.CLIENT)
public final class SyncRenderers {
    public static void initClient() {
        SyncRenderers.register(ShellStorageBlockEntityRenderer::new, SyncBlockEntities.SHELL_STORAGE);
        SyncRenderers.register(ShellConstructorBlockEntityRenderer::new, SyncBlockEntities.SHELL_CONSTRUCTOR);
        SyncRenderers.register(TreadmillBlockEntityRenderer::new, SyncBlockEntities.TREADMILL);
    }

    private static <E extends BlockEntity> void register(BlockEntityRendererProvider<? super E> rendererFactory, BlockEntityType<E> blockEntityType) {
        BlockEntityRendererRegistry.register(blockEntityType, rendererFactory);
        ResourceLocation id = BuiltInRegistries.f_257049_.m_7981_(blockEntityType);
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
        if (BuiltInRegistries.f_256975_.m_7981_((Object)block).equals((Object)BuiltInRegistries.f_256975_.m_122315_()) || BuiltInRegistries.f_257033_.m_7981_((Object)item).equals((Object)BuiltInRegistries.f_257033_.m_122315_())) {
            return;
        }
        BlockEntity renderEntity = blockEntityType.m_155264_(BlockPos.f_121853_, block.m_49966_());
        BuiltinItemRendererRegistry.INSTANCE.register((ItemLike)item, (itemStack, transform, stack, source, light, overlay) -> Minecraft.m_91087_().m_167982_().m_112272_(renderEntity, stack, source, light, overlay));
    }
}

