/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.render.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.block.entity.AbstractShellContainerBlockEntity;
import dev.kir.sync.client.model.AbstractShellContainerModel;
import dev.kir.sync.client.model.DoubleBlockModel;
import dev.kir.sync.client.render.block.entity.DoubleBlockEntityRenderer;
import dev.kir.sync.entity.ShellEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractShellContainerBlockEntityRenderer<T extends AbstractShellContainerBlockEntity>
extends DoubleBlockEntityRenderer<T> {
    public AbstractShellContainerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        super.m_6922_(blockEntity, tickDelta, matrices, vertexConsumers, light, overlay);
        if (((AbstractShellContainerBlockEntity)blockEntity).getShellState() != null) {
            this.renderShell(((AbstractShellContainerBlockEntity)blockEntity).getShellState(), blockEntity, tickDelta, this.getBlockState(blockEntity), matrices, vertexConsumers, light);
        }
    }

    protected void renderShell(ShellState shellState, T blockEntity, float tickDelta, BlockState blockState, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        float yaw = this.getFacing(blockState).m_122424_().m_122435_();
        ShellEntity shellEntity = this.createEntity(shellState, blockEntity, tickDelta);
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)shellEntity);
        renderer.m_7392_((Entity)shellEntity, yaw, 0.0f, matrices, vertexConsumers, light);
    }

    @Override
    protected DoubleBlockModel getModel(T blockEntity, BlockState blockState, float tickDelta) {
        AbstractShellContainerModel model = this.getShellContainerModel(blockEntity, blockState, tickDelta);
        model.doorOpenProgress = ((AbstractShellContainerBlockEntity)blockEntity).getDoorOpenProgress(tickDelta);
        return model;
    }

    protected abstract ShellEntity createEntity(ShellState var1, T var2, float var3);

    protected abstract AbstractShellContainerModel getShellContainerModel(T var1, BlockState var2, float var3);
}

