/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.render.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.kir.sync.block.entity.DoubleBlockEntity;
import dev.kir.sync.client.model.DoubleBlockModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@Environment(value=EnvType.CLIENT)
public abstract class DoubleBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    protected final BlockEntityRendererProvider.Context context;

    public DoubleBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void m_6922_(T blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        BlockState blockState = this.getBlockState(blockEntity);
        matrices.m_85836_();
        Direction face = this.getFacing(blockState);
        float rotation = face.m_122435_();
        matrices.m_85837_(0.5, 0.75, 0.5);
        matrices.m_85841_(-0.5f, -0.5f, 0.5f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotation));
        DoubleBlockModel model = this.getModel(blockEntity, blockState, tickDelta);
        VertexConsumer consumer = vertexConsumers.m_6299_(model.m_103119_(this.getTextureId()));
        if (blockEntity.m_58898_()) {
            model.render(((DoubleBlockEntity)blockEntity).getBlockType(blockState), matrices, consumer, light, overlay);
        } else {
            model.render(matrices, consumer, light, overlay);
        }
        matrices.m_85849_();
    }

    protected BlockState getBlockState(T blockEntity) {
        return blockEntity.m_58898_() ? blockEntity.m_58900_() : this.getDefaultState();
    }

    protected Direction getFacing(BlockState blockState) {
        return (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    protected abstract DoubleBlockModel getModel(T var1, BlockState var2, float var3);

    protected abstract BlockState getDefaultState();

    protected abstract ResourceLocation getTextureId();
}

