/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.render.block.entity;

import dev.kir.sync.Sync;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.block.AbstractShellContainerBlock;
import dev.kir.sync.block.SyncBlocks;
import dev.kir.sync.block.entity.ShellStorageBlockEntity;
import dev.kir.sync.client.model.AbstractShellContainerModel;
import dev.kir.sync.client.model.ShellStorageModel;
import dev.kir.sync.client.render.block.entity.AbstractShellContainerBlockEntityRenderer;
import dev.kir.sync.entity.ShellEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

@Environment(value=EnvType.CLIENT)
public class ShellStorageBlockEntityRenderer
extends AbstractShellContainerBlockEntityRenderer<ShellStorageBlockEntity> {
    private static final ResourceLocation SHELL_STORAGE_TEXTURE_ID = Sync.locate("textures/block/shell_storage.png");
    private static final BlockState DEFAULT_STATE = (BlockState)((BlockState)((BlockState)SyncBlocks.SHELL_STORAGE.m_49966_().m_61124_(AbstractShellContainerBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)AbstractShellContainerBlock.FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)AbstractShellContainerBlock.OPEN, (Comparable)Boolean.valueOf(false));
    private final ShellStorageModel model = new ShellStorageModel();

    public ShellStorageBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected AbstractShellContainerModel getShellContainerModel(ShellStorageBlockEntity blockEntity, BlockState blockState, float tickDelta) {
        this.model.ledColor = blockEntity.getIndicatorColor();
        this.model.connectorProgress = blockEntity.getConnectorProgress(tickDelta);
        return this.model;
    }

    @Override
    protected ShellEntity createEntity(ShellState shellState, ShellStorageBlockEntity blockEntity, float tickDelta) {
        ShellEntity entity = shellState.asEntity();
        entity.isActive = shellState.getProgress() >= 1.0f;
        entity.pitchProgress = entity.isActive ? blockEntity.getConnectorProgress(tickDelta) : 0.0f;
        return entity;
    }

    @Override
    protected BlockState getDefaultState() {
        return DEFAULT_STATE;
    }

    @Override
    protected ResourceLocation getTextureId() {
        return SHELL_STORAGE_TEXTURE_ID;
    }
}

