/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.kir.sync.client.texture.TextureGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

@Environment(value=EnvType.CLIENT)
public final class GeneratedTextureManager {
    private static final Map<TextureGenerator, ResourceLocation[]> GENERATED_TEXTURES = new HashMap<TextureGenerator, ResourceLocation[]>();
    private static final ResourceLocation[] EMPTY_TEXTURES = new ResourceLocation[0];

    public static ResourceLocation[] getTextures(TextureGenerator generator) {
        ResourceLocation[] textures = GENERATED_TEXTURES.get(generator);
        if (textures == null) {
            if (RenderSystem.isOnRenderThreadOrInit()) {
                textures = GeneratedTextureManager.genTextures(generator, GENERATED_TEXTURES.size());
                GENERATED_TEXTURES.put(generator, textures);
            } else {
                RenderSystem.recordRenderCall(() -> GENERATED_TEXTURES.put(generator, GeneratedTextureManager.genTextures(generator, GENERATED_TEXTURES.size())));
                textures = EMPTY_TEXTURES;
            }
        }
        return textures;
    }

    private static ResourceLocation[] genTextures(TextureGenerator generator, int generatorId) {
        RenderSystem.assertOnRenderThreadOrInit();
        int textureCounter = -1;
        String format = generator.getClass().getSimpleName().toLowerCase() + "_" + generatorId + "_";
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        for (AbstractTexture texture : generator.generateTextures()::iterator) {
            ResourceLocation id = new ResourceLocation("__dynamic", format + ++textureCounter);
            textureManager.m_118495_(id, texture);
            textures.add(id);
        }
        return textures.toArray(new ResourceLocation[0]);
    }
}

