/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import dev.kir.sync.client.texture.TextureGenerator;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.FastColor;
import net.minecraft.util.Tuple;

@Environment(value=EnvType.CLIENT)
public final class TextureGenerators {
    public static final TextureGenerator PlayerEntityPartiallyTexturedTextureGenerator = new PlayerEntityPartiallyTexturedTextureGenerator();

    private static class PlayerEntityPartiallyTexturedTextureGenerator
    implements TextureGenerator {
        private static final int TEXTURE_SIZE = 64;
        private static final int BLOCKS = 32;
        private static final int TRANSPARENT = FastColor.ABGR32.m_266248_((int)0, (int)0, (int)0, (int)0);
        private static final int WHITE = FastColor.ABGR32.m_266248_((int)255, (int)255, (int)255, (int)255);
        private static final Tuple<Tuple<Integer, Integer>, Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>>>[] REGIONS = new Tuple[]{new Tuple((Object)new Tuple((Object)0, (Object)0), (Object)new Tuple((Object)new Tuple((Object)8, (Object)0), (Object)new Tuple((Object)8, (Object)8))), new Tuple((Object)new Tuple((Object)1, (Object)8), (Object)new Tuple((Object)new Tuple((Object)0, (Object)8), (Object)new Tuple((Object)32, (Object)8))), new Tuple((Object)new Tuple((Object)9, (Object)9), (Object)new Tuple((Object)new Tuple((Object)16, (Object)0), (Object)new Tuple((Object)8, (Object)8))), new Tuple((Object)new Tuple((Object)9, (Object)9), (Object)new Tuple((Object)new Tuple((Object)20, (Object)16), (Object)new Tuple((Object)8, (Object)4))), new Tuple((Object)new Tuple((Object)9, (Object)9), (Object)new Tuple((Object)new Tuple((Object)44, (Object)16), (Object)new Tuple((Object)4, (Object)4))), new Tuple((Object)new Tuple((Object)9, (Object)9), (Object)new Tuple((Object)new Tuple((Object)36, (Object)48), (Object)new Tuple((Object)4, (Object)4))), new Tuple((Object)new Tuple((Object)9, (Object)20), (Object)new Tuple((Object)new Tuple((Object)16, (Object)20), (Object)new Tuple((Object)24, (Object)12))), new Tuple((Object)new Tuple((Object)9, (Object)20), (Object)new Tuple((Object)new Tuple((Object)40, (Object)20), (Object)new Tuple((Object)16, (Object)12))), new Tuple((Object)new Tuple((Object)9, (Object)20), (Object)new Tuple((Object)new Tuple((Object)32, (Object)52), (Object)new Tuple((Object)16, (Object)12))), new Tuple((Object)new Tuple((Object)21, (Object)21), (Object)new Tuple((Object)new Tuple((Object)28, (Object)16), (Object)new Tuple((Object)8, (Object)4))), new Tuple((Object)new Tuple((Object)21, (Object)21), (Object)new Tuple((Object)new Tuple((Object)48, (Object)16), (Object)new Tuple((Object)4, (Object)4))), new Tuple((Object)new Tuple((Object)21, (Object)21), (Object)new Tuple((Object)new Tuple((Object)40, (Object)48), (Object)new Tuple((Object)4, (Object)4))), new Tuple((Object)new Tuple((Object)21, (Object)21), (Object)new Tuple((Object)new Tuple((Object)4, (Object)16), (Object)new Tuple((Object)4, (Object)4))), new Tuple((Object)new Tuple((Object)21, (Object)21), (Object)new Tuple((Object)new Tuple((Object)20, (Object)48), (Object)new Tuple((Object)4, (Object)4))), new Tuple((Object)new Tuple((Object)21, (Object)32), (Object)new Tuple((Object)new Tuple((Object)0, (Object)20), (Object)new Tuple((Object)16, (Object)12))), new Tuple((Object)new Tuple((Object)21, (Object)32), (Object)new Tuple((Object)new Tuple((Object)16, (Object)52), (Object)new Tuple((Object)16, (Object)12)))};
        private final int multiplier;

        public PlayerEntityPartiallyTexturedTextureGenerator() {
            this(1);
        }

        public PlayerEntityPartiallyTexturedTextureGenerator(int multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Stream<AbstractTexture> generateTextures() {
            int textureSize = 64 * this.multiplier;
            int textureCount = 32 * this.multiplier;
            ArrayList<AbstractTexture> textures = new ArrayList<AbstractTexture>(textureCount + 1);
            for (int i = 0; i <= textureCount; ++i) {
                textures.add(dev.kir.sync.client.texture.TextureGenerators$PlayerEntityPartiallyTexturedTextureGenerator.generateTexture(textureSize, (float)i / (float)textureCount));
            }
            return textures.stream();
        }

        private static AbstractTexture generateTexture(int textureSize, float emptiness) {
            Tuple limit;
            NativeImage img = new NativeImage(textureSize, textureSize, false);
            int multiplier = textureSize / 64;
            float lastBlock = (float)(32 * multiplier) * emptiness;
            img.m_84997_(0, 0, textureSize, textureSize, TRANSPARENT);
            for (int i = REGIONS.length - 1; i >= 0 && !(lastBlock > (float)((Integer)(limit = (Tuple)REGIONS[i].m_14418_()).m_14419_()).intValue()); --i) {
                Tuple pos = (Tuple)((Tuple)REGIONS[i].m_14419_()).m_14418_();
                Tuple size = (Tuple)((Tuple)REGIONS[i].m_14419_()).m_14419_();
                if (lastBlock > (float)((Integer)limit.m_14418_()).intValue()) {
                    int oldY = (Integer)pos.m_14419_() * multiplier;
                    int y = (int)(((float)((Integer)pos.m_14419_()).intValue() + lastBlock - (float)((Integer)limit.m_14418_()).intValue()) * (float)multiplier);
                    int height = (Integer)size.m_14419_() * multiplier - (y - oldY);
                    img.m_84997_((Integer)pos.m_14418_() * multiplier, y, (Integer)size.m_14418_() * multiplier, height, WHITE);
                    continue;
                }
                img.m_84997_((Integer)pos.m_14418_() * multiplier, (Integer)pos.m_14419_() * multiplier, (Integer)size.m_14418_() * multiplier, (Integer)size.m_14419_() * multiplier, WHITE);
            }
            return new DynamicTexture(img);
        }
    }
}

