/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateContainer;
import dev.kir.sync.command.Command;
import dev.kir.sync.util.WorldUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;

public class GhostShellsCommand
implements Command {
    private static final SimpleCommandExceptionType INVALID_ACTION_TYPE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.sync.ghostshells.invalid_action"));

    @Override
    public String getName() {
        return "ghostshells";
    }

    @Override
    public boolean hasPermissions(CommandSourceStack commandSource) {
        int OP_LEVEL = 2;
        return commandSource.m_6761_(2) || commandSource.m_81377_().m_129792_();
    }

    @Override
    public void build(ArgumentBuilder<CommandSourceStack, ?> builder) {
        builder.then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((a, b) -> SharedSuggestionProvider.m_82970_(Set.of("sync", "remove", "repair"), (SuggestionsBuilder)b)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(GhostShellsCommand::execute)).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(GhostShellsCommand::execute))));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos;
        boolean repair;
        String type;
        boolean canSkip = switch (type = StringArgumentType.getString(context, (String)"type")) {
            case "sync" -> {
                repair = true;
                yield true;
            }
            case "remove" -> {
                repair = false;
                yield true;
            }
            case "repair" -> {
                repair = true;
                yield false;
            }
            default -> throw INVALID_ACTION_TYPE.create();
        };
        Consumer<Component> logger = x -> ((CommandSourceStack)context.getSource()).m_288197_(() -> x, false);
        Collection players = EntityArgument.m_91477_(context, (String)"target");
        try {
            pos = BlockPosArgument.m_264582_(context, (String)"pos");
        }
        catch (IllegalArgumentException e) {
            pos = null;
        }
        if (pos == null) {
            for (ServerPlayer player : players) {
                GhostShellsCommand.updateShells(player, repair, canSkip, logger);
            }
        } else {
            BlockPos finalPos = pos;
            for (ServerPlayer player : players) {
                ShellState shellState = ((Shell)player).getAvailableShellStates().filter(x -> x.getPos().equals((Object)finalPos)).findAny().orElse(null);
                if (shellState == null) {
                    logger.accept((Component)Component.m_237110_((String)"command.sync.ghostshells.not_found", (Object[])new Object[]{player.m_7755_().getString(), pos.m_123344_()}));
                    continue;
                }
                GhostShellsCommand.updateShell(player, shellState, repair, canSkip, logger);
            }
        }
        return 1;
    }

    private static void updateShells(ServerPlayer player, boolean shouldRepair, boolean skipOnFailure, Consumer<Component> logger) {
        for (ShellState shellState : ((Shell)player).getAvailableShellStates()::iterator) {
            shellState.setProgress(100.0f);
            GhostShellsCommand.updateShell(player, shellState, shouldRepair, skipOnFailure, logger);
        }
    }

    private static void updateShell(ServerPlayer player, ShellState shellState, boolean shouldRepair, boolean skipOnFailure, Consumer<Component> logger) {
        if (GhostShellsCommand.shellExists(player.f_8924_, shellState)) {
            return;
        }
        if (shouldRepair) {
            if (GhostShellsCommand.tryRepair(player.f_8924_, shellState)) {
                logger.accept((Component)Component.m_237110_((String)"command.sync.ghostshells.repaired", (Object[])new Object[]{player.m_7755_().getString(), shellState.getPos().m_123344_()}));
                return;
            }
            if (!skipOnFailure) {
                logger.accept((Component)Component.m_237110_((String)"command.sync.ghostshells.failed", (Object[])new Object[]{player.m_7755_().getString(), shellState.getPos().m_123344_()}));
                return;
            }
        }
        ((Shell)player).remove(shellState);
        logger.accept((Component)Component.m_237110_((String)"command.sync.ghostshells.removed", (Object[])new Object[]{player.m_7755_().getString(), shellState.getPos().m_123344_()}));
    }

    private static boolean shellExists(MinecraftServer server, ShellState shellState) {
        return GhostShellsCommand.getShellContainer(server, shellState).map(x -> shellState.equals(x.getShellState())).orElse(Boolean.FALSE);
    }

    private static boolean tryRepair(MinecraftServer server, ShellState shellState) {
        ShellStateContainer shellContainer = GhostShellsCommand.getShellContainer(server, shellState).orElse(null);
        if (shellContainer == null) {
            return false;
        }
        if (shellContainer.getShellState() == null) {
            shellContainer.setShellState(shellState);
        }
        return shellState.equals(shellContainer.getShellState());
    }

    private static Optional<ShellStateContainer> getShellContainer(MinecraftServer server, ShellState shellState) {
        ServerLevel world = WorldUtil.findWorld(server.m_129785_(), shellState.getWorld()).orElse(null);
        if (world == null) {
            return Optional.empty();
        }
        ChunkAccess chunk = world.m_46865_(shellState.getPos());
        if (chunk == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ShellStateContainer.find((Level)world, shellState));
    }
}

