/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.kir.sync.command.Command;
import dev.kir.sync.command.GhostShellsCommand;
import dev.kir.sync.util.reflect.Activator;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;

public class SyncCommands {
    private static final Set<Command> COMMANDS = new HashSet<Command>();

    public static void init() {
        SyncCommands.register(GhostShellsCommand.class);
    }

    private static <T extends Command> void register(Class<T> type) {
        COMMANDS.add((Command)Activator.createInstance(type));
    }

    private static void init(MinecraftServer server) {
        LiteralArgumentBuilder commandBuilder = LiteralArgumentBuilder.literal((String)"sync");
        commandBuilder.requires(x -> COMMANDS.stream().anyMatch(c -> c.hasPermissions((CommandSourceStack)x)));
        for (Command commandInfo : COMMANDS) {
            LiteralArgumentBuilder command = Commands.m_82127_((String)commandInfo.getName());
            command.requires(commandInfo::hasPermissions);
            commandInfo.build((ArgumentBuilder<CommandSourceStack, ?>)command);
            commandBuilder.then((ArgumentBuilder)command);
        }
        CommandDispatcher commandDispatcher = server.m_129892_().m_82094_();
        commandDispatcher.register(commandBuilder);
    }

    static {
        ServerLifecycleEvents.SERVER_STARTING.register(SyncCommands::init);
    }
}

