/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.compat.mixin.iris;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import dev.kir.sync.client.render.entity.ShellEntityRenderer;
import dev.kir.sync.client.texture.GeneratedTextureManager;
import dev.kir.sync.client.texture.TextureGenerators;
import dev.kir.sync.compat.iris.IrisRenderLayer;
import dev.kir.sync.entity.ShellEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ShellEntityRenderer.class})
final class ShellEntityRendererMixin
extends PlayerRenderer {
    private ShellEntityRendererMixin(EntityRendererProvider.Context ctx, boolean slim) {
        super(ctx, slim);
    }

    @Inject(method={"getVertexConsumerForPartiallyTexturedEntity"}, at={@At(value="RETURN")}, cancellable=true)
    private void getVertexConsumerForPartiallyTexturedEntity(ShellEntity shellEntity, float progress, RenderType baseLayer, MultiBufferSource vertexConsumers, CallbackInfoReturnable<VertexConsumer> cir) {
        VertexConsumer baseConsumer = (VertexConsumer)cir.getReturnValue();
        if (!(progress >= 0.75f) || !(progress < 1.0f)) {
            return;
        }
        ResourceLocation[] textures = GeneratedTextureManager.getTextures(TextureGenerators.PlayerEntityPartiallyTexturedTextureGenerator);
        if (textures.length == 0) {
            return;
        }
        float printingProgress = (progress - 0.75f) / 0.25f;
        RenderType printingMaskLayer = IrisRenderLayer.getPrintingMask(textures[(int)((float)textures.length * printingProgress)]);
        VertexConsumer printingMaskVertexConsumer = vertexConsumers.m_6299_(printingMaskLayer);
        if (printingMaskVertexConsumer == baseConsumer) {
            cir.setReturnValue((Object)vertexConsumers.m_6299_(baseLayer));
            return;
        }
        cir.setReturnValue((Object)VertexMultiConsumer.m_86168_((VertexConsumer)printingMaskVertexConsumer, (VertexConsumer)baseConsumer));
    }
}

