/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.compat.origins;

import dev.kir.sync.api.shell.ShellStateComponent;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.registry.ModComponents;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

class OriginsShellStateComponent
extends ShellStateComponent {
    private final ServerPlayer player;
    private boolean activated;
    private CompoundTag originComponentNbt;
    private CompoundTag powerHolderComponentNbt;

    public OriginsShellStateComponent() {
        this(null, false);
    }

    public OriginsShellStateComponent(ServerPlayer player) {
        this(player, true);
    }

    private OriginsShellStateComponent(ServerPlayer player, boolean activated) {
        this.player = player;
        this.activated = activated;
    }

    @Override
    public String getId() {
        return "origins";
    }

    public boolean isActivated() {
        return this.activated;
    }

    public CompoundTag getOriginComponentNbt() {
        CompoundTag nbt = this.originComponentNbt;
        if (this.player != null) {
            nbt = new CompoundTag();
            ((OriginComponent)ModComponents.ORIGIN.get((Object)this.player)).writeToNbt(nbt);
        }
        return nbt == null ? new CompoundTag() : nbt;
    }

    public CompoundTag getPowerHolderComponentNbt() {
        CompoundTag nbt = this.powerHolderComponentNbt;
        if (this.player != null) {
            nbt = new CompoundTag();
            ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player)).writeToNbt(nbt);
        }
        return nbt == null ? new CompoundTag() : nbt;
    }

    @Override
    public void clone(ShellStateComponent component) {
        OriginsShellStateComponent other = component.as(OriginsShellStateComponent.class);
        if (other == null) {
            return;
        }
        this.originComponentNbt = other.getOriginComponentNbt();
        this.powerHolderComponentNbt = other.getPowerHolderComponentNbt();
        this.activated = other.isActivated();
        if (this.player == null) {
            return;
        }
        OriginComponent originComponent = (OriginComponent)ModComponents.ORIGIN.get((Object)this.player);
        if (this.activated) {
            originComponent.readFromNbt(this.originComponentNbt);
            PowerHolderComponent powerHolderComponent = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.player);
            powerHolderComponent.readFromNbt(this.powerHolderComponentNbt);
            originComponent.sync();
        } else {
            for (OriginLayer layer : OriginLayers.getLayers()) {
                if (!layer.isEnabled()) continue;
                originComponent.setOrigin(layer, Origin.EMPTY);
            }
            originComponent.checkAutoChoosingLayers((Player)this.player, false);
            originComponent.sync();
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
            data.writeBoolean(false);
            ServerPlayNetworking.send((ServerPlayer)this.player, (ResourceLocation)ModPackets.OPEN_ORIGIN_SCREEN, (FriendlyByteBuf)data);
            this.activated = true;
        }
    }

    @Override
    protected void readComponentNbt(CompoundTag nbt) {
        this.originComponentNbt = nbt.m_128425_("origins", 10) ? nbt.m_128469_("origins") : new CompoundTag();
        this.powerHolderComponentNbt = nbt.m_128425_("powers", 10) ? nbt.m_128469_("powers") : new CompoundTag();
        this.activated = nbt.m_128471_("activated");
    }

    @Override
    protected CompoundTag writeComponentNbt(CompoundTag nbt) {
        nbt.m_128365_("origins", (Tag)this.getOriginComponentNbt());
        nbt.m_128365_("powers", (Tag)this.getPowerHolderComponentNbt());
        nbt.m_128379_("activated", this.isActivated());
        return nbt;
    }
}

