/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.compat.trinkets;

import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.TrinketsApi;
import dev.kir.sync.api.shell.ShellStateComponent;
import dev.kir.sync.item.SimpleInventory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

class TrinketShellStateComponent
extends ShellStateComponent {
    final Map<String, Map<String, Container>> inventory;

    public TrinketShellStateComponent(LivingEntity entity) {
        this.inventory = TrinketsApi.getTrinketComponent((LivingEntity)entity).map(x -> x.getInventory()).orElseGet(HashMap::new);
    }

    public TrinketShellStateComponent(EntityType<?> entityType) {
        this.inventory = new HashMap<String, Map<String, Container>>();
        for (Map.Entry groupEntry : TrinketsApi.getEntitySlots(entityType).entrySet()) {
            Map group = this.inventory.computeIfAbsent((String)groupEntry.getKey(), x -> new HashMap());
            for (Map.Entry slotEntry : ((SlotGroup)groupEntry.getValue()).getSlots().entrySet()) {
                group.put((String)slotEntry.getKey(), new SimpleInventory());
            }
        }
    }

    @Override
    public String getId() {
        return "trinkets";
    }

    @Override
    public Collection<ItemStack> getItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Container inv : this.inventory.values().stream().flatMap(x -> x.values().stream())::iterator) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (stack.m_41619_()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    public void clear() {
        this.inventory.values().forEach(x -> x.values().forEach(Clearable::m_6211_));
    }

    @Override
    public void clone(ShellStateComponent component) {
        this.clear();
        TrinketShellStateComponent trinketComponent = component.as(TrinketShellStateComponent.class);
        if (trinketComponent == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Container>> sourceGroupEntry : trinketComponent.inventory.entrySet()) {
            Map<String, Container> targetGroup = this.inventory.get(sourceGroupEntry.getKey());
            if (targetGroup == null) continue;
            for (Map.Entry<String, Container> sourceSlotEntry : sourceGroupEntry.getValue().entrySet()) {
                Container targetSlot = targetGroup.get(sourceSlotEntry.getKey());
                if (targetSlot == null) continue;
                Container sourceSlot = sourceSlotEntry.getValue();
                int size = Math.min(sourceSlot.m_6643_(), targetSlot.m_6643_());
                for (int i = 0; i < size; ++i) {
                    targetSlot.m_6836_(i, sourceSlot.m_8020_(i));
                }
            }
        }
    }

    @Override
    public CompoundTag writeComponentNbt(CompoundTag nbt) {
        for (Map.Entry<String, Map<String, Container>> group : this.inventory.entrySet()) {
            CompoundTag groupTag = new CompoundTag();
            for (Map.Entry<String, Container> slot : group.getValue().entrySet()) {
                CompoundTag slotTag = new CompoundTag();
                ListTag list = new ListTag();
                Container inv = slot.getValue();
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    list.add((Object)inv.m_8020_(i).m_41739_(new CompoundTag()));
                }
                slotTag.m_128365_("Items", (Tag)list);
                groupTag.m_128365_(slot.getKey(), (Tag)slotTag);
            }
            nbt.m_128365_(group.getKey(), (Tag)groupTag);
        }
        return nbt;
    }

    @Override
    public void readComponentNbt(CompoundTag nbt) {
        for (String groupKey : nbt.m_128431_()) {
            CompoundTag groupTag = nbt.m_128469_(groupKey);
            Map<String, Container> groupSlots = this.inventory.get(groupKey);
            if (groupTag == null || groupSlots == null) continue;
            for (String slotKey : groupTag.m_128431_()) {
                CompoundTag slotTag = groupTag.m_128469_(slotKey);
                ListTag list = slotTag.m_128437_("Items", 10);
                Container inv = groupSlots.get(slotKey);
                if (inv == null) continue;
                int size = Math.min(list.size(), inv.m_6643_());
                for (int i = 0; i < size; ++i) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                    inv.m_6836_(i, stack);
                }
            }
        }
    }
}

