/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.easteregg.mixin.technoblade;

import dev.kir.sync.easteregg.technoblade.Technoblade;
import dev.kir.sync.easteregg.technoblade.TechnobladeTransformable;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ClientLevel.class})
abstract class ClientWorldMixin
extends Level {
    @Shadow
    @Final
    private Minecraft f_104565_;

    protected ClientWorldMixin(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Inject(method={"playSound(DDDLnet/minecraft/sound/SoundEvent;Lnet/minecraft/sound/SoundCategory;FFZJ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void playSound(double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, boolean useDistance, long seed, CallbackInfo ci) {
        Mob entity;
        if (category != SoundSource.NEUTRAL) {
            return;
        }
        List Technoblades = this.m_6443_(Mob.class, new AABB(x - 0.1, y - 0.1, z - 0.1, x + 0.1, y + 0.1, z + 0.1), e -> e instanceof TechnobladeTransformable && ((TechnobladeTransformable)e).isTechnoblade());
        Mob mob = entity = Technoblades.size() == 0 ? null : (Mob)Technoblades.get(0);
        if (entity == null) {
            return;
        }
        Technoblade Technoblade2 = ((TechnobladeTransformable)entity).asTechnoblade();
        if ((sound = this.getTechnobladeSound(sound)) == null) {
            ci.cancel();
            return;
        }
        double distance = this.f_104565_.f_91063_.m_109153_().m_90583_().m_82531_(x, y, z);
        SimpleSoundInstance positionedSoundInstance = new SimpleSoundInstance(sound, Technoblade2.m_5720_(), volume, pitch, RandomSource.m_216335_((long)seed), x, y, z);
        if (useDistance && distance > 100.0) {
            this.f_104565_.m_91106_().m_120369_((SoundInstance)positionedSoundInstance, (int)(Math.sqrt(distance) * 0.5));
        } else {
            this.f_104565_.m_91106_().m_120367_((SoundInstance)positionedSoundInstance);
        }
        ci.cancel();
    }

    @Inject(method={"playSoundFromEntity(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/registry/entry/RegistryEntry;Lnet/minecraft/sound/SoundCategory;FFJ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void playSoundFromEntity(Player source, Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed, CallbackInfo ci) {
        if (source != this.f_104565_.f_91074_ || !(entity instanceof TechnobladeTransformable) || !((TechnobladeTransformable)entity).isTechnoblade()) {
            return;
        }
        Technoblade Technoblade2 = ((TechnobladeTransformable)entity).asTechnoblade();
        SoundEvent sound1 = this.getTechnobladeSound((SoundEvent)sound.m_203334_());
        if (sound1 == null) {
            ci.cancel();
            return;
        }
        this.f_104565_.m_91106_().m_120367_((SoundInstance)new EntityBoundSoundInstance(sound1, Technoblade2.m_5720_(), volume, pitch, entity, seed));
        ci.cancel();
    }

    @Nullable
    private SoundEvent getTechnobladeSound(SoundEvent sound) {
        ResourceLocation originalSoundId = sound.m_11660_();
        if (originalSoundId.m_135815_().endsWith(".ambient") || originalSoundId.m_135815_().endsWith(".death")) {
            return null;
        }
        SoundEvent fixedSound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation(originalSoundId.m_135827_(), originalSoundId.m_135815_().replaceFirst("\\.[^.]+", ".player")));
        if (fixedSound == null) {
            fixedSound = sound;
        }
        return fixedSound;
    }
}

