/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.easteregg.technoblade;

import com.mojang.authlib.GameProfile;
import dev.kir.sync.Sync;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.block.state.BlockState;

@Environment(value=EnvType.CLIENT)
public class Technoblade
extends AbstractClientPlayer {
    private static final ResourceLocation TECHNOBLADE_SKIN = Sync.locate("textures/entity/technoblade.png");
    private static final GameProfile TECHNOBLADE_GAME_PROFILE = new GameProfile(UUID.fromString("b876ec32-e396-476b-a115-8438d83c67d4"), "Technoblade");
    private static final PlayerInfo TECHNOBLADE_PLAYER_LIST_ENTRY = new PlayerInfo(TECHNOBLADE_GAME_PROFILE, false);
    private static final List<Component> TECHNOBLADE_QUOTES = Stream.of("so long nerds", "Officer, I drop kicked that child in self defense", "PEE VEE PEE", "Not even close, baby", "Technoblade never dies", "\"The opportunity of defeating the enemy is provided by the enemy himself.\" - Sun Tzu, The Art of War", "All part of the master plan", "i stab children for coins").map(Component::m_130674_).toList();
    private int ticksSinceLastQuote = 0;

    private Technoblade(ClientLevel world) {
        super(world, TECHNOBLADE_GAME_PROFILE);
    }

    public static Technoblade from(LivingEntity entity) {
        if (!entity.m_9236_().f_46443_) {
            return null;
        }
        Technoblade Technoblade2 = new Technoblade((ClientLevel)entity.m_9236_());
        Technoblade2.copyPose(entity);
        return Technoblade2;
    }

    protected PlayerInfo m_108558_() {
        return TECHNOBLADE_PLAYER_LIST_ENTRY;
    }

    public boolean m_36170_(PlayerModelPart modelPart) {
        if (modelPart == PlayerModelPart.CAPE) {
            return Sync.getConfig().renderTechnobladeCape();
        }
        return true;
    }

    public SoundEvent m_5592_() {
        return super.m_5592_();
    }

    public SoundEvent m_7975_(DamageSource source) {
        return super.m_7975_(source);
    }

    public void m_7355_(BlockPos pos, BlockState state) {
        super.m_7355_(pos, state);
    }

    public Component getRandomQuote() {
        return TECHNOBLADE_QUOTES.get(this.f_19796_.m_188503_(TECHNOBLADE_QUOTES.size()));
    }

    public void speak() {
        Component quote = this.getRandomQuote();
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"chat.type.text", (Object[])new Object[]{this.m_5446_(), quote.getString()}));
    }

    public void m_8119_() {
        super.m_8119_();
        if (Sync.getConfig().allowTechnobladeQuotes()) {
            this.tickSpeaking();
        }
    }

    private void tickSpeaking() {
        if (this.ticksSinceLastQuote++ < Sync.getConfig().TechnobladeQuoteDelay()) {
            return;
        }
        if (this.f_19796_.m_188501_() < 0.05f) {
            this.speak();
            this.ticksSinceLastQuote = 0;
        }
    }

    public void copyPose(LivingEntity entity) {
        this.m_20359_((Entity)entity);
        this.f_19790_ = entity.f_19790_;
        this.f_19791_ = entity.f_19791_;
        this.f_19792_ = entity.f_19792_;
        this.f_20885_ = entity.f_20885_;
        this.f_20886_ = entity.f_20886_;
        this.f_20883_ = entity.f_20883_;
        this.f_20884_ = entity.f_20884_;
        this.m_146922_(entity.m_146908_());
        this.f_19859_ = entity.f_19859_;
        this.f_20890_ = entity.m_21224_();
        this.f_20919_ = entity.f_20919_;
    }
}

