/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.easteregg.technoblade;

import dev.kir.sync.Sync;
import dev.kir.sync.easteregg.technoblade.TechnobladeTransformable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public final class TechnobladeManager {
    private static final Set<BlockPos> POSITIONS = new HashSet<BlockPos>(List.of(new BlockPos(1, 6, 1999), new BlockPos(6, 1, 1999), new BlockPos(1999, 6, 1), new BlockPos(30, 6, 2022), new BlockPos(6, 30, 2022), new BlockPos(2022, 6, 30)));

    public static void refreshTechnobladeStatus(Entity entity) {
        if (Sync.getConfig().isTechnoblade(entity.m_20148_())) {
            TechnobladeManager.transformEntityIntoTechnoblade(entity, false);
        }
    }

    public static void refreshTechnobladeStatus(Entity entity, BlockPos pos) {
        if (entity instanceof TechnobladeTransformable && POSITIONS.contains(pos)) {
            TechnobladeManager.transformEntityIntoTechnoblade(entity, true);
        }
    }

    private static void transformEntityIntoTechnoblade(Entity entity, boolean shouldAnnounce) {
        if (((TechnobladeTransformable)entity).transformIntoTechnoblade()) {
            Sync.getConfig().addTechnoblade(entity.m_20148_());
            if (shouldAnnounce && Sync.getConfig().allowTechnobladeAnnouncements()) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"multiplayer.player.joined", (Object[])new Object[]{((TechnobladeTransformable)entity).asTechnoblade().m_5446_()}));
            }
        }
    }

    static {
        if (!Sync.getConfig().enableTechnobladeEasterEgg()) {
            Sync.getConfig().clearTechnobladeCache();
        }
    }
}

