/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.entity;

import dev.kir.sync.entity.PersistentCameraEntityGoal;
import java.util.Date;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

@Environment(value=EnvType.CLIENT)
public class PersistentCameraEntity
extends LocalPlayer {
    private long lastMovementTime;
    private float initialYaw;
    private float initialPitch;
    private double initialDistance;
    private PersistentCameraEntityGoal goal;

    private PersistentCameraEntity(Minecraft client) {
        super(client, Objects.requireNonNull(client.f_91074_).f_108545_, client.f_91074_.f_108617_, client.f_91074_.m_108630_(), client.f_91074_.m_108631_(), false, false);
        LocalPlayer player = client.f_91074_;
        this.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
        this.m_19915_(player.m_146908_(), player.m_146909_());
        this.updateLastTickValues();
        this.f_19794_ = true;
    }

    public boolean m_5833_() {
        return true;
    }

    public void m_8107_() {
        PersistentCameraEntityGoal goal = this.goal;
        long currentTime = new Date().getTime();
        if (goal == null || this.lastMovementTime < 0L) {
            this.lastMovementTime = currentTime;
            return;
        }
        if (this.lastMovementTime > currentTime) {
            return;
        }
        this.updateLastTickValues();
        Vec3 currentPos = this.m_20182_();
        Vec3 currentVelocity = this.m_20184_();
        Vec3 newPos = currentPos.m_82549_(currentVelocity.m_82490_((double)(currentTime - this.lastMovementTime)));
        Vec3 currentDiff = goal.pos.m_82546_(currentPos);
        Vec3 newDiff = goal.pos.m_82546_(newPos);
        if (Math.signum(currentDiff.f_82479_) != Math.signum(newDiff.f_82479_)) {
            newPos = new Vec3(goal.pos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            currentVelocity = new Vec3(0.0, currentVelocity.f_82480_, currentVelocity.f_82481_);
        }
        if (Math.signum(currentDiff.f_82480_) != Math.signum(newDiff.f_82480_)) {
            newPos = new Vec3(newPos.f_82479_, goal.pos.f_82480_, newPos.f_82481_);
            currentVelocity = new Vec3(currentVelocity.f_82479_, 0.0, currentVelocity.f_82481_);
        }
        if (Math.signum(currentDiff.f_82481_) != Math.signum(newDiff.f_82481_)) {
            newPos = new Vec3(newPos.f_82479_, newPos.f_82480_, goal.pos.f_82481_);
            currentVelocity = new Vec3(currentVelocity.f_82479_, currentVelocity.f_82480_, 0.0);
        }
        this.m_146884_(newPos);
        this.m_20256_(currentVelocity);
        float factor = 1.0f - (float)(goal.pos.m_82554_(newPos) / this.initialDistance);
        float newYaw = this.initialYaw + (goal.yaw - this.initialYaw) * factor;
        float newPitch = this.initialPitch + (goal.pitch - this.initialPitch) * factor;
        this.m_7678_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, newYaw, newPitch);
        this.m_19915_(newYaw, newPitch);
        this.m_146922_(newYaw);
        this.m_5616_(newYaw);
        this.m_5618_(newYaw);
        this.f_108585_ += (newYaw - this.f_108585_) * 0.5f;
        this.f_108586_ += (newPitch - this.f_108586_) * 0.5f;
        this.lastMovementTime = currentTime;
        if (this.m_20182_().equals((Object)goal.pos)) {
            this.updateLastTickValues();
            this.setGoal(null);
            goal.finish(this);
        }
    }

    private void updateLastTickValues() {
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.f_108587_ = this.f_108585_;
        this.f_108588_ = this.f_108586_;
        this.f_20886_ = this.f_20885_;
    }

    public void setGoal(PersistentCameraEntityGoal goal) {
        this.goal = goal;
        this.initialYaw = this.m_146908_();
        this.initialPitch = this.m_146909_();
        this.lastMovementTime = -1L;
        double dX = 0.0;
        double dY = 0.0;
        double dZ = 0.0;
        double duration = 0.0;
        if (goal != null) {
            Vec3 pos = this.m_20182_();
            dX = goal.pos.f_82479_ - pos.f_82479_;
            dY = goal.pos.f_82480_ - pos.f_82480_;
            dZ = goal.pos.f_82481_ - pos.f_82481_;
            duration = goal.duration;
            if (goal.delay > 0L) {
                this.lastMovementTime = new Date().getTime() + goal.delay;
            }
        }
        this.initialDistance = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        this.m_20256_(new Vec3(dX, dY, dZ).m_82490_(1.0 / Math.max(1.0, duration)));
    }

    public PersistentCameraEntityGoal getGoal() {
        return this.goal;
    }

    public static void setup(Minecraft client, PersistentCameraEntityGoal goal) {
        LocalPlayer player = client.f_91074_;
        if (player == null || player.f_108545_ == null) {
            return;
        }
        if (!(client.m_91288_() instanceof PersistentCameraEntity)) {
            client.m_91118_((Entity)new PersistentCameraEntity(client));
        }
        PersistentCameraEntity camera = (PersistentCameraEntity)Objects.requireNonNull(client.m_91288_());
        camera.setGoal(goal);
    }

    public static void unset(Minecraft client) {
        Entity entity = client.m_91288_();
        if (entity instanceof PersistentCameraEntity) {
            PersistentCameraEntity camera = (PersistentCameraEntity)entity;
            camera.setGoal(null);
            client.m_91118_((Entity)client.f_91074_);
        }
    }

    private static void onTick(Minecraft client) {
        PersistentCameraEntity camera;
        block3: {
            block2: {
                Entity entity = client.m_91288_();
                if (!(entity instanceof PersistentCameraEntity)) break block2;
                camera = (PersistentCameraEntity)entity;
                if (camera.goal != null) break block3;
            }
            return;
        }
        camera.m_8107_();
    }

    static {
        ClientTickEvents.START_CLIENT_TICK.register(PersistentCameraEntity::onTick);
    }
}

