/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.entity;

import dev.kir.sync.entity.PersistentCameraEntity;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

@Environment(value=EnvType.CLIENT)
public class PersistentCameraEntityGoal {
    public static final double MAX_DISTANCE = 25.0;
    public static final long PHASE_DELAY = 200L;
    public static final double MAX_Y = 320.0;
    public static final long MIN_PHASE_DURATION = 400L;
    public static final long MAX_PHASE_DURATION = 2500L;
    public final Vec3 pos;
    public final float yaw;
    public final float pitch;
    public final long delay;
    public final long duration;
    private final Consumer<PersistentCameraEntity> onTransitionFinished;

    private PersistentCameraEntityGoal(Vec3 pos, float yaw, float pitch, long delay, long duration, Consumer<PersistentCameraEntity> onTransitionFinished) {
        this.pos = pos;
        this.yaw = yaw;
        this.pitch = pitch;
        this.delay = delay;
        this.duration = duration;
        this.onTransitionFinished = onTransitionFinished;
    }

    public void finish(PersistentCameraEntity camera) {
        if (this.onTransitionFinished != null) {
            this.onTransitionFinished.accept(camera);
        }
    }

    public PersistentCameraEntityGoal then(PersistentCameraEntityGoal nextGoal) {
        return this.then((PersistentCameraEntity camera) -> camera.setGoal(nextGoal));
    }

    public PersistentCameraEntityGoal then(Consumer<PersistentCameraEntity> callback) {
        Consumer<PersistentCameraEntity> combined = callback == null ? this.onTransitionFinished : (this.onTransitionFinished == null ? callback : this.onTransitionFinished.andThen(callback));
        return new PersistentCameraEntityGoal(this.pos, this.yaw, this.pitch, this.delay, this.duration, combined);
    }

    public static PersistentCameraEntityGoal create(BlockPos pos, float yaw, float pitch, long duration) {
        return PersistentCameraEntityGoal.create(pos, yaw, pitch, 0L, duration, null);
    }

    public static PersistentCameraEntityGoal create(BlockPos pos, float yaw, float pitch, long delay, long duration, Consumer<PersistentCameraEntity> onTransitionFinished) {
        Vec3 vecPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        return PersistentCameraEntityGoal.create(vecPos, yaw, pitch, delay, duration, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal create(Vec3 pos, float yaw, float pitch, long duration) {
        return PersistentCameraEntityGoal.create(pos, yaw, pitch, 0L, duration, null);
    }

    public static PersistentCameraEntityGoal create(Vec3 pos, float yaw, float pitch, long delay, long duration, Consumer<PersistentCameraEntity> onTransitionFinished) {
        return new PersistentCameraEntityGoal(pos, yaw, pitch, delay, duration, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal tp(BlockPos pos, float yaw, float pitch) {
        return PersistentCameraEntityGoal.create(pos, yaw, pitch, 0L, 0L, null);
    }

    public static PersistentCameraEntityGoal tp(BlockPos pos, float yaw, float pitch, Consumer<PersistentCameraEntity> onTransitionFinished) {
        return PersistentCameraEntityGoal.create(pos, yaw, pitch, 0L, 0L, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal limbo(BlockPos start, Direction startFacing, BlockPos target, Consumer<PersistentCameraEntity> onTransitionFinished) {
        return PersistentCameraEntityGoal.limbo(start, startFacing, 320.0, target, 400L, 2500L, 200L, 25.0, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal limbo(BlockPos start, Direction startFacing, double y, BlockPos target, long firstPhaseDuration, long secondPhaseDuration, long phaseDelay, double maxDistance, Consumer<PersistentCameraEntity> onTransitionFinished) {
        double dZ;
        double dX = target.m_123341_() - start.m_123341_();
        double horizontalDistance = Math.sqrt(dX * dX + (dZ = (double)(target.m_123343_() - start.m_123343_())) * dZ);
        if (horizontalDistance > maxDistance) {
            double factor = maxDistance / horizontalDistance;
            target = new BlockPos((Vec3i)start.m_7918_((int)(dX * factor), 0, (int)(dZ * factor)));
        }
        float yaw = startFacing.m_122435_();
        float pitch = 90.0f;
        BlockPos pos0 = start.m_121945_(Direction.UP);
        Vec3 pos1 = new Vec3((double)(start.m_123341_() + target.m_123341_()), y * 2.0, (double)(start.m_123343_() + target.m_123343_())).m_82490_(0.5);
        PersistentCameraEntityGoal goal0 = PersistentCameraEntityGoal.create(pos0, yaw, pitch, firstPhaseDuration);
        PersistentCameraEntityGoal goal1 = PersistentCameraEntityGoal.create(pos1, yaw, pitch, phaseDelay, secondPhaseDuration, onTransitionFinished);
        return goal0.then(goal1);
    }

    public static PersistentCameraEntityGoal stairwayToHeaven(BlockPos start, Direction startFacing, BlockPos target, Consumer<PersistentCameraEntity> onTransitionFinished) {
        return PersistentCameraEntityGoal.stairwayToHeaven(start, startFacing, 320.0, target, 400L, 2500L, 200L, 25.0, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal stairwayToHeaven(BlockPos start, Direction startFacing, double y, BlockPos target, long firstPhaseDuration, long secondPhaseDuration, long phaseDelay, double maxDistance, Consumer<PersistentCameraEntity> onTransitionFinished) {
        double dZ;
        double dX = target.m_123341_() - start.m_123341_();
        double horizontalDistance = Math.sqrt(dX * dX + (dZ = (double)(target.m_123343_() - start.m_123343_())) * dZ);
        if (horizontalDistance > maxDistance) {
            double factor = maxDistance / horizontalDistance;
            target = new BlockPos((Vec3i)start.m_7918_((int)(dX * factor), 0, (int)(dZ * factor)));
        }
        float yaw = startFacing.m_122435_();
        float pitch = 90.0f;
        BlockPos pos0 = start.m_121945_(startFacing.m_122424_());
        Vec3 pos1 = new Vec3((double)(start.m_123341_() + target.m_123341_()), y * 2.0, (double)(start.m_123343_() + target.m_123343_())).m_82490_(0.5);
        PersistentCameraEntityGoal goal0 = PersistentCameraEntityGoal.create(pos0, yaw, 0.0f, firstPhaseDuration);
        PersistentCameraEntityGoal goal1 = PersistentCameraEntityGoal.create(pos1, yaw, pitch, phaseDelay, secondPhaseDuration, onTransitionFinished);
        return goal0.then(goal1);
    }

    public static PersistentCameraEntityGoal highwayToHell(BlockPos start, Direction startFacing, BlockPos target, Direction targetFacing, Consumer<PersistentCameraEntity> onTransitionFinished) {
        return PersistentCameraEntityGoal.highwayToHell(start, startFacing, 320.0, target, targetFacing, 2500L, 400L, 200L, 25.0, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal highwayToHell(BlockPos start, Direction startFacing, double y, BlockPos target, Direction targetFacing, long firstPhaseDuration, long secondPhaseDuration, long phaseDelay, double maxDistance, Consumer<PersistentCameraEntity> onTransitionFinished) {
        double dZ;
        BlockPos pos0 = target.m_121945_(targetFacing.m_122424_());
        float yaw0 = targetFacing.m_122435_();
        float yaw1 = targetFacing.m_122424_().m_122435_();
        Vec3 centerPoint = new Vec3((double)(start.m_123341_() + target.m_123341_()), y * 2.0, (double)(start.m_123343_() + target.m_123343_())).m_82490_(0.5);
        PersistentCameraEntityGoal tpGoal = null;
        double dX = centerPoint.f_82479_ - (double)target.m_123341_();
        double horizontalDistance = Math.sqrt(dX * dX + (dZ = centerPoint.f_82481_ - (double)target.m_123343_()) * dZ);
        if (horizontalDistance > maxDistance) {
            double factor = maxDistance / horizontalDistance;
            BlockPos centerPointPos = new BlockPos((Vec3i)target.m_7918_((int)(dX * factor), 0, (int)(dZ * factor))).m_175288_((int)centerPoint.f_82480_);
            tpGoal = PersistentCameraEntityGoal.tp(centerPointPos, startFacing.m_122435_(), 90.0f);
        }
        PersistentCameraEntityGoal goal0 = PersistentCameraEntityGoal.create(pos0, yaw0, 0.0f, firstPhaseDuration);
        PersistentCameraEntityGoal goal1 = PersistentCameraEntityGoal.create(target, yaw1, 0.0f, phaseDelay, secondPhaseDuration, onTransitionFinished);
        return tpGoal == null ? goal0.then(goal1) : tpGoal.then(goal0.then(goal1));
    }
}

