/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.entity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import dev.kir.sync.api.shell.ShellState;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.PlayerModelPart;

@Environment(value=EnvType.CLIENT)
public class ShellEntity
extends RemotePlayer {
    private static final Cache<UUID, PlayerInfo> PLAYER_ENTRY_CACHE = CacheBuilder.newBuilder().initialCapacity(20).maximumSize(40L).expireAfterAccess(20L, TimeUnit.MINUTES).build();
    public boolean isActive = false;
    public float pitchProgress = 0.0f;
    private final ShellState state;
    private Runnable onInitialized;
    private final PlayerInfo playerEntry;

    public ShellEntity(ShellState state) {
        this(Minecraft.m_91087_().f_91073_, state);
    }

    public ShellEntity(ClientLevel world, ShellState state) {
        super(world, ShellEntity.getPlayerEntry(state).m_105312_());
        this.state = state;
        state.getInventory().copyTo((Container)this.m_150109_());
        this.playerEntry = ShellEntity.getPlayerEntry(state);
        this.m_20035_(state.getPos(), 0.0f, 0.0f);
        this.f_36102_ = this.f_36105_ = this.m_20185_() + 0.5;
        this.f_36103_ = this.f_36106_ = this.m_20186_();
        this.f_36104_ = this.f_36075_ = this.m_20189_() + 0.5;
        if (this.onInitialized != null) {
            this.onInitialized.run();
            this.onInitialized = null;
        }
    }

    public void onInitialized(Runnable runnable) {
        if (this.state == null) {
            this.onInitialized = runnable;
        } else if (runnable != null) {
            runnable.run();
        }
    }

    public ShellState getState() {
        return this.state;
    }

    protected void m_5907_() {
    }

    protected void m_21226_() {
    }

    public boolean m_7500_() {
        return true;
    }

    public boolean m_5833_() {
        return false;
    }

    public boolean m_6052_() {
        return false;
    }

    public boolean m_36170_(PlayerModelPart modelPart) {
        return true;
    }

    protected PlayerInfo m_108558_() {
        return this.playerEntry;
    }

    private static PlayerInfo getPlayerEntry(ShellState state) {
        PlayerInfo entry = (PlayerInfo)PLAYER_ENTRY_CACHE.getIfPresent((Object)state.getOwnerUuid());
        if (entry == null) {
            Minecraft client = Minecraft.m_91087_();
            ClientPacketListener networkHandler = client.m_91403_();
            if (networkHandler != null && (entry = networkHandler.m_104949_(state.getOwnerUuid())) == null) {
                entry = networkHandler.m_104938_(state.getOwnerName());
            }
            if (entry == null) {
                entry = new PlayerInfo(new GameProfile(state.getOwnerUuid(), state.getOwnerName()), false);
            }
            PLAYER_ENTRY_CACHE.put((Object)state.getOwnerUuid(), (Object)entry);
        }
        return entry;
    }
}

