/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SimpleInventory
implements Container,
Nameable {
    public final NonNullList<ItemStack> main = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
    public final NonNullList<ItemStack> armor = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public final NonNullList<ItemStack> offHand = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private final List<NonNullList<ItemStack>> combinedInventory = ImmutableList.of(this.main, this.armor, this.offHand);
    public int selectedSlot;
    private int changeCount;

    public void m_6836_(int slot, ItemStack stack) {
        for (NonNullList<ItemStack> inventory : this.combinedInventory) {
            if (slot < inventory.size()) {
                inventory.set(slot, (Object)stack);
                return;
            }
            slot -= inventory.size();
        }
    }

    public ItemStack m_7407_(int slot, int amount) {
        for (NonNullList<ItemStack> inventory : this.combinedInventory) {
            if (slot < inventory.size()) {
                return !((ItemStack)inventory.get(slot)).m_41619_() ? ContainerHelper.m_18969_(inventory, (int)slot, (int)amount) : ItemStack.f_41583_;
            }
            slot -= inventory.size();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        for (NonNullList<ItemStack> inventory : this.combinedInventory) {
            if (slot < inventory.size()) {
                if (!((ItemStack)inventory.get(slot)).m_41619_()) {
                    ItemStack itemStack = (ItemStack)inventory.get(slot);
                    inventory.set(slot, (Object)ItemStack.f_41583_);
                    return itemStack;
                }
                return ItemStack.f_41583_;
            }
            slot -= inventory.size();
        }
        return ItemStack.f_41583_;
    }

    public int m_6643_() {
        return this.main.size() + this.armor.size() + this.offHand.size();
    }

    public void m_6211_() {
        for (NonNullList<ItemStack> itemStacks : this.combinedInventory) {
            itemStacks.clear();
        }
    }

    public boolean m_7983_() {
        return this.combinedInventory.stream().flatMap(Collection::stream).allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int slot) {
        for (NonNullList<ItemStack> inventory : this.combinedInventory) {
            if (slot < inventory.size()) {
                return (ItemStack)inventory.get(slot);
            }
            slot -= inventory.size();
        }
        return ItemStack.f_41583_;
    }

    public Component m_7755_() {
        return Component.m_130674_((String)"container.inventory");
    }

    public void m_6596_() {
        ++this.changeCount;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    public ListTag writeNbt(ListTag nbtList) {
        for (Map.Entry<NonNullList<ItemStack>, Integer> inventoryInfo : Map.of(this.main, 0, this.armor, 100, this.offHand, 150).entrySet()) {
            NonNullList<ItemStack> inventory = inventoryInfo.getKey();
            int delta = inventoryInfo.getValue();
            for (int i = 0; i < inventory.size(); ++i) {
                if (((ItemStack)inventory.get(i)).m_41619_()) continue;
                CompoundTag compound = new CompoundTag();
                compound.m_128344_("Slot", (byte)(i + delta));
                ((ItemStack)inventory.get(i)).m_41739_(compound);
                nbtList.add((Object)compound);
            }
        }
        return nbtList;
    }

    public void readNbt(ListTag nbtList) {
        this.main.clear();
        this.armor.clear();
        this.offHand.clear();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int j = nbtCompound.m_128445_("Slot") & 0xFF;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)nbtCompound);
            if (itemStack.m_41619_()) continue;
            if (j < this.main.size()) {
                this.main.set(j, (Object)itemStack);
                continue;
            }
            if (j >= 100 && j < this.armor.size() + 100) {
                this.armor.set(j - 100, (Object)itemStack);
                continue;
            }
            if (j < 150 || j >= this.offHand.size() + 150) continue;
            this.offHand.set(j - 150, (Object)itemStack);
        }
    }

    public void clone(Container other) {
        int thisSize = this.m_6643_();
        int otherSize = other.m_6643_();
        for (int i = 0; i < thisSize; ++i) {
            this.m_6836_(i, i < otherSize ? other.m_8020_(i) : ItemStack.f_41583_);
        }
        if (other instanceof Inventory) {
            Inventory playerInventory = (Inventory)other;
            this.selectedSlot = playerInventory.f_35977_;
        } else if (other instanceof SimpleInventory) {
            SimpleInventory simpleInventory = (SimpleInventory)other;
            this.selectedSlot = simpleInventory.selectedSlot;
        }
    }

    public void copyTo(Container other) {
        int thisSize = this.m_6643_();
        int otherSize = other.m_6643_();
        for (int i = 0; i < otherSize; ++i) {
            other.m_6836_(i, i < thisSize ? this.m_8020_(i) : ItemStack.f_41583_);
        }
        if (other instanceof Inventory) {
            Inventory playerInventory = (Inventory)other;
            playerInventory.f_35977_ = this.selectedSlot;
        } else if (other instanceof SimpleInventory) {
            SimpleInventory simpleInventory = (SimpleInventory)other;
            simpleInventory.selectedSlot = this.selectedSlot;
        }
    }
}

