/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.mixin;

import com.mojang.authlib.GameProfile;
import dev.kir.sync.Sync;
import dev.kir.sync.api.event.PlayerSyncEvents;
import dev.kir.sync.api.networking.SynchronizationRequestPacket;
import dev.kir.sync.api.shell.ClientShell;
import dev.kir.sync.api.shell.ShellPriority;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.client.gui.controller.DeathScreenController;
import dev.kir.sync.client.gui.controller.HudController;
import dev.kir.sync.config.SyncConfig;
import dev.kir.sync.entity.KillableEntity;
import dev.kir.sync.entity.LookingEntity;
import dev.kir.sync.entity.PersistentCameraEntity;
import dev.kir.sync.entity.PersistentCameraEntityGoal;
import dev.kir.sync.util.BlockPosUtil;
import dev.kir.sync.util.WorldUtil;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={LocalPlayer.class})
abstract class ClientPlayerEntityMixin
extends AbstractClientPlayer
implements ClientShell,
KillableEntity,
LookingEntity {
    @Final
    @Shadow
    protected Minecraft f_108619_;
    @Unique
    private boolean isArtificial = false;
    @Unique
    private ConcurrentMap<UUID, ShellState> shellsById = new ConcurrentHashMap<UUID, ShellState>();

    private ClientPlayerEntityMixin(ClientLevel world, GameProfile profile) {
        super(world, profile);
    }

    @Override
    @Nullable
    public PlayerSyncEvents.SyncFailureReason beginSync(ShellState state) {
        PlayerSyncEvents.SyncFailureReason failureReason;
        ClientLevel world = this.f_108545_;
        if (world == null) {
            return PlayerSyncEvents.SyncFailureReason.OTHER_PROBLEM;
        }
        PlayerSyncEvents.SyncFailureReason syncFailureReason = failureReason = this.canBeApplied(state) && state.getProgress() >= 1.0f ? ((PlayerSyncEvents.AllowSyncing)PlayerSyncEvents.ALLOW_SYNCING.invoker()).allowSync((Player)this, state) : PlayerSyncEvents.SyncFailureReason.INVALID_SHELL;
        if (failureReason != null) {
            return failureReason;
        }
        ((PlayerSyncEvents.StartSyncing)PlayerSyncEvents.START_SYNCING.invoker()).onStartSyncing((Player)this, state);
        BlockPos pos = this.m_20183_();
        Direction facing = BlockPosUtil.getHorizontalFacing(pos, (BlockGetter)world).orElse(this.m_6350_().m_122424_());
        SynchronizationRequestPacket request = new SynchronizationRequestPacket(state);
        PersistentCameraEntityGoal cameraGoal = this.m_21224_() ? PersistentCameraEntityGoal.limbo(pos, facing, state.getPos(), __ -> request.send()) : PersistentCameraEntityGoal.stairwayToHeaven(pos, facing, state.getPos(), __ -> request.send());
        HudController.hide();
        if (this.m_21224_()) {
            DeathScreenController.suspend();
        }
        this.f_108619_.m_91152_(null);
        PersistentCameraEntity.setup(this.f_108619_, cameraGoal);
        return null;
    }

    @Override
    public void endSync(ResourceLocation startWorld, BlockPos startPos, Direction startFacing, ResourceLocation targetWorld, BlockPos targetPos, Direction targetFacing, @Nullable ShellState storedState) {
        LocalPlayer player = (LocalPlayer)this;
        boolean syncFailed = Objects.equals(startPos, targetPos);
        if (!syncFailed) {
            if (this.m_21223_() <= 0.0f) {
                this.m_21153_(0.01f);
            }
            this.f_20919_ = 0;
        }
        float yaw = targetFacing.m_122424_().m_122435_();
        this.m_146922_(yaw);
        this.f_19859_ = yaw;
        this.f_20884_ = this.f_20883_ = yaw;
        this.f_20886_ = this.f_20885_ = yaw;
        player.f_108587_ = player.f_108585_ = yaw;
        this.m_146926_(0.0f);
        this.f_19860_ = 0.0f;
        player.f_108586_ = 0.0f;
        player.f_108588_ = 0.0f;
        Runnable restore = () -> {
            PersistentCameraEntity.unset(this.f_108619_);
            HudController.restore();
            DeathScreenController.restore();
            if (!syncFailed) {
                ((PlayerSyncEvents.StopSyncing)PlayerSyncEvents.STOP_SYNCING.invoker()).onStopSyncing((Player)this, startPos, storedState);
            }
        };
        boolean enableCamera = Objects.equals(startWorld, targetWorld);
        if (enableCamera) {
            PersistentCameraEntityGoal cameraGoal = PersistentCameraEntityGoal.highwayToHell(startPos, startFacing, targetPos, targetFacing, __ -> restore.run());
            PersistentCameraEntity.setup(this.f_108619_, cameraGoal);
        } else {
            restore.run();
        }
    }

    @Override
    public UUID getShellOwnerUuid() {
        return this.m_36316_().getId();
    }

    @Override
    public boolean isArtificial() {
        return this.isArtificial;
    }

    @Override
    public void changeArtificialStatus(boolean isArtificial) {
        this.isArtificial = isArtificial;
    }

    @Override
    public void setAvailableShellStates(Stream<ShellState> states) {
        this.shellsById = states.collect(Collectors.toConcurrentMap(ShellState::getUuid, x -> x));
    }

    @Override
    public Stream<ShellState> getAvailableShellStates() {
        return this.shellsById.values().stream();
    }

    @Override
    public ShellState getShellStateByUuid(UUID uuid) {
        return uuid == null ? null : (ShellState)this.shellsById.get(uuid);
    }

    @Override
    public void add(ShellState state) {
        if (this.canBeApplied(state)) {
            this.shellsById.put(state.getUuid(), state);
        }
    }

    @Override
    public void remove(ShellState state) {
        if (state != null) {
            this.shellsById.remove(state.getUuid());
        }
    }

    @Override
    public void update(ShellState state) {
        if (this.canBeApplied(state) || state != null && this.shellsById.containsKey(state.getUuid())) {
            this.shellsById.put(state.getUuid(), state);
        }
    }

    @Override
    public boolean changeLookingEntityLookDirection(double cursorDeltaX, double cursorDeltaY) {
        return this.f_108619_.m_91288_() instanceof PersistentCameraEntity;
    }

    @Override
    public void onKillableEntityDeath() {
        ShellState respawnShell;
        boolean canRespawn = this.shellsById.values().stream().anyMatch(s -> this.canBeApplied((ShellState)s) && s.getProgress() >= 1.0f);
        BlockPos pos = this.m_20183_();
        ResourceLocation world = WorldUtil.getId(this.m_9236_());
        Comparator<ShellState> comparator = ShellPriority.asComparator(world, pos, Sync.getConfig().syncPriority().stream().map(SyncConfig.ShellPriorityEntry::priority));
        ShellState shellState = respawnShell = canRespawn ? (ShellState)this.shellsById.values().stream().filter(x -> this.canBeApplied((ShellState)x) && x.getProgress() >= 1.0f).min(comparator).orElse(null) : null;
        if (respawnShell != null) {
            this.beginSync(respawnShell);
        }
    }

    @Inject(method={"updatePostDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private void updatePostDeath(CallbackInfo ci) {
        if (this.f_108619_.f_91080_ instanceof DeathScreen) {
            this.f_20919_ = Mth.m_14045_((int)this.f_20919_, (int)0, (int)19);
        } else {
            this.f_20919_ = Mth.m_14045_((int)(++this.f_20919_), (int)0, (int)20);
            ci.cancel();
        }
    }
}

