/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.mixin;

import com.google.common.collect.ImmutableMap;
import dev.kir.sync.client.render.entity.ShellEntityRenderer;
import dev.kir.sync.entity.ShellEntity;
import dev.kir.sync.mixin.LivingEntityRendererAccessor;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.impl.client.rendering.RegistrationHelperImpl;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={EntityRenderDispatcher.class})
abstract class EntityRenderDispatcherMixin {
    @Shadow
    @Final
    private ItemRenderer f_173995_;
    @Shadow
    @Final
    private Font f_114365_;
    @Shadow
    @Final
    private EntityModelSet f_173996_;
    @Shadow
    @Final
    private ItemInHandRenderer f_234577_;
    @Shadow
    @Final
    private BlockRenderDispatcher f_234576_;
    @Unique
    private Map<String, EntityRenderer<? extends Player>> shellRenderers = ImmutableMap.of();

    EntityRenderDispatcherMixin() {
    }

    @Inject(method={"getRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    private <T extends Entity> void getRenderer(T entity, CallbackInfoReturnable<EntityRenderer<? super T>> cir) {
        if (entity instanceof ShellEntity) {
            ShellEntity shell = (ShellEntity)entity;
            EntityRenderer<? extends Player> renderer = this.shellRenderers.get(shell.m_108564_());
            cir.setReturnValue(renderer);
        }
    }

    @Inject(method={"reload"}, at={@At(value="HEAD")})
    private void reload(ResourceManager manager, CallbackInfo ci) {
        EntityRendererProvider.Context context = new EntityRendererProvider.Context((EntityRenderDispatcher)this, this.f_173995_, this.f_234576_, this.f_234577_, manager, this.f_173996_, this.f_114365_);
        this.shellRenderers = ImmutableMap.of((Object)"default", (Object)((Object)EntityRenderDispatcherMixin.createShellEntityRenderer(context, false)), (Object)"slim", (Object)((Object)EntityRenderDispatcherMixin.createShellEntityRenderer(context, true)));
    }

    private static ShellEntityRenderer createShellEntityRenderer(EntityRendererProvider.Context context, boolean slim) {
        ShellEntityRenderer shellEntityRenderer = new ShellEntityRenderer(context, slim);
        LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)((Object)shellEntityRenderer);
        ((LivingEntityFeatureRendererRegistrationCallback)LivingEntityFeatureRendererRegistrationCallback.EVENT.invoker()).registerRenderers(EntityType.f_20532_, (LivingEntityRenderer)shellEntityRenderer, (LivingEntityFeatureRendererRegistrationCallback.RegistrationHelper)new RegistrationHelperImpl(accessor::executeAddFeature), context);
        return shellEntityRenderer;
    }
}

