/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.mixin;

import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateManager;
import dev.kir.sync.api.shell.ShellStateUpdateType;
import dev.kir.sync.util.nbt.OfflinePlayerNbtManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Tuple;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
abstract class MinecraftServerMixin
implements ShellStateManager {
    @Shadow
    private PlayerList f_129763_;
    @Unique
    private final ConcurrentMap<UUID, ConcurrentMap<UUID, Tuple<ShellStateUpdateType, ShellState>>> pendingShellStates = new ConcurrentHashMap<UUID, ConcurrentMap<UUID, Tuple<ShellStateUpdateType, ShellState>>>();

    MinecraftServerMixin() {
    }

    @Override
    public void setAvailableShellStates(UUID owner, Stream<ShellState> states) {
        Shell shell = this.getShellById(owner);
        if (shell != null) {
            shell.setAvailableShellStates(states);
        }
    }

    @Override
    public Stream<ShellState> getAvailableShellStates(UUID owner) {
        Shell shell = this.getShellById(owner);
        return shell == null ? Stream.of(new ShellState[0]) : shell.getAvailableShellStates();
    }

    @Override
    public ShellState getShellStateByUuid(UUID owner, UUID uuid) {
        Shell shell = this.getShellById(owner);
        return shell == null ? null : shell.getShellStateByUuid(uuid);
    }

    @Override
    public void add(ShellState state) {
        Shell shell = this.getShellByItsState(state);
        if (shell != null) {
            shell.add(state);
        }
    }

    @Override
    public void remove(ShellState state) {
        Shell shell = this.getShellByItsState(state);
        if (shell == null) {
            this.putPendingUpdate(state, ShellStateUpdateType.REMOVE);
        } else {
            shell.remove(state);
        }
    }

    @Override
    public void update(ShellState state) {
        Shell shell = this.getShellByItsState(state);
        if (shell == null) {
            this.putPendingUpdate(state, ShellStateUpdateType.UPDATE);
        } else {
            shell.update(state);
        }
    }

    @Override
    public Collection<Tuple<ShellStateUpdateType, ShellState>> peekPendingUpdates(UUID owner) {
        Map shells = (Map)this.pendingShellStates.get(owner);
        if (shells == null) {
            return List.of();
        }
        return shells.values();
    }

    @Override
    public void clearPendingUpdates(UUID owner) {
        this.pendingShellStates.remove(owner);
    }

    @Inject(method={"shutdown"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;disconnectAllPlayers()V")})
    private void onShutdown(CallbackInfo ci) {
        for (Map.Entry entry : this.pendingShellStates.entrySet()) {
            UUID userId = (UUID)entry.getKey();
            Collection updates = ((ConcurrentMap)entry.getValue()).values();
            if (updates.size() == 0) continue;
            OfflinePlayerNbtManager.editPlayerNbt((MinecraftServer)this, userId, nbt -> {
                Map<UUID, ShellState> shells = nbt.m_128437_("Shells", 10).stream().map(x -> ShellState.fromNbt((CompoundTag)x)).collect(Collectors.toMap(ShellState::getUuid, x -> x));
                for (Tuple update : updates) {
                    ShellState state = (ShellState)update.m_14419_();
                    switch ((ShellStateUpdateType)((Object)((Object)update.m_14418_()))) {
                        case ADD: 
                        case UPDATE: {
                            if (!userId.equals(state.getOwnerUuid())) break;
                            shells.put(state.getUuid(), state);
                            break;
                        }
                        case REMOVE: {
                            shells.remove(state.getUuid());
                        }
                    }
                }
                ListTag shellList = new ListTag();
                shells.values().stream().map(x -> x.writeNbt(new CompoundTag())).forEach(arg_0 -> shellList.add(arg_0));
                nbt.m_128365_("Shells", (Tag)shellList);
            });
        }
        this.pendingShellStates.clear();
    }

    @Unique
    private void putPendingUpdate(ShellState state, ShellStateUpdateType updateType) {
        if (state == null || updateType == ShellStateUpdateType.NONE) {
            return;
        }
        ConcurrentHashMap<UUID, Tuple> updates = (ConcurrentHashMap<UUID, Tuple>)this.pendingShellStates.get(state.getOwnerUuid());
        if (updates == null) {
            updates = new ConcurrentHashMap<UUID, Tuple>();
            this.pendingShellStates.put(state.getOwnerUuid(), updates);
        }
        updates.put(state.getUuid(), new Tuple((Object)updateType, (Object)state));
    }

    @Unique
    private Shell getShellById(UUID id) {
        return this.isValidShellOwnerUuid(id) ? (Shell)this.f_129763_.m_11259_(id) : null;
    }

    @Unique
    private Shell getShellByItsState(ShellState state) {
        return this.isValidShellState(state) ? (Shell)this.f_129763_.m_11259_(state.getOwnerUuid()) : null;
    }
}

