/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import dev.kir.sync.api.event.PlayerSyncEvents;
import dev.kir.sync.api.networking.PlayerIsAlivePacket;
import dev.kir.sync.api.networking.ShellStateUpdatePacket;
import dev.kir.sync.api.networking.ShellUpdatePacket;
import dev.kir.sync.api.shell.ServerShell;
import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateComponent;
import dev.kir.sync.api.shell.ShellStateContainer;
import dev.kir.sync.api.shell.ShellStateManager;
import dev.kir.sync.api.shell.ShellStateUpdateType;
import dev.kir.sync.entity.KillableEntity;
import dev.kir.sync.util.BlockPosUtil;
import dev.kir.sync.util.WorldUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
abstract class ServerPlayerEntityMixin
extends Player
implements ServerShell,
KillableEntity {
    @Shadow
    private int f_8920_;
    @Shadow
    private float f_8917_;
    @Shadow
    private int f_8918_;
    @Final
    @Shadow
    public MinecraftServer f_8924_;
    @Shadow
    public ServerGamePacketListenerImpl f_8906_;
    @Unique
    private boolean isArtificial = false;
    @Unique
    private boolean shellDirty = false;
    @Unique
    private boolean undead = false;
    @Unique
    private ConcurrentMap<UUID, ShellState> shellsById = new ConcurrentHashMap<UUID, ShellState>();
    @Unique
    private Map<UUID, Tuple<ShellStateUpdateType, ShellState>> shellStateChanges = new ConcurrentHashMap<UUID, Tuple<ShellStateUpdateType, ShellState>>();
    @Shadow
    private boolean f_8927_;

    private ServerPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Override
    public UUID getShellOwnerUuid() {
        return this.m_36316_().getId();
    }

    @Override
    public boolean isArtificial() {
        return this.isArtificial;
    }

    @Override
    public void changeArtificialStatus(boolean isArtificial) {
        if (this.isArtificial != isArtificial) {
            this.isArtificial = isArtificial;
            this.shellDirty = true;
        }
    }

    @Override
    public Either<ShellState, PlayerSyncEvents.SyncFailureReason> sync(ShellState state) {
        PlayerSyncEvents.SyncFailureReason finalFailureReason;
        ShellStateContainer targetShellContainer;
        ShellStateContainer currentShellContainer;
        ServerPlayer player = (ServerPlayer)this;
        BlockPos currentPos = this.m_20183_();
        Level currentWorld = player.m_9236_();
        if (!this.canBeApplied(state) || state.getProgress() < 1.0f) {
            return Either.right((Object)PlayerSyncEvents.SyncFailureReason.INVALID_SHELL);
        }
        boolean isDead = this.m_21224_();
        ShellStateContainer shellStateContainer = currentShellContainer = isDead ? null : ShellStateContainer.find(currentWorld, currentPos);
        if (!(isDead || currentShellContainer != null && currentShellContainer.getShellState() == null)) {
            return Either.right((Object)PlayerSyncEvents.SyncFailureReason.INVALID_CURRENT_LOCATION);
        }
        PlayerSyncEvents.ShellSelectionFailureReason selectionFailureReason = ((PlayerSyncEvents.AllowShellSelection)PlayerSyncEvents.ALLOW_SHELL_SELECTION.invoker()).allowShellSelection((Player)player, currentShellContainer);
        if (selectionFailureReason != null) {
            return Either.right(selectionFailureReason::toText);
        }
        ResourceLocation targetWorldId = state.getWorld();
        ServerLevel targetWorld = WorldUtil.findWorld(this.f_8924_.m_129785_(), targetWorldId).orElse(null);
        if (targetWorld == null) {
            return Either.right((Object)PlayerSyncEvents.SyncFailureReason.INVALID_TARGET_LOCATION);
        }
        BlockPos targetPos = state.getPos();
        ChunkAccess targetChunk = targetWorld.m_46865_(targetPos);
        ShellStateContainer shellStateContainer2 = targetShellContainer = targetChunk == null ? null : ShellStateContainer.find((Level)targetWorld, state);
        if (targetShellContainer == null) {
            return Either.right((Object)PlayerSyncEvents.SyncFailureReason.INVALID_TARGET_LOCATION);
        }
        state = targetShellContainer.getShellState();
        PlayerSyncEvents.SyncFailureReason syncFailureReason = finalFailureReason = this.canBeApplied(state) ? ((PlayerSyncEvents.AllowSyncing)PlayerSyncEvents.ALLOW_SYNCING.invoker()).allowSync(this, state) : PlayerSyncEvents.SyncFailureReason.INVALID_SHELL;
        if (finalFailureReason != null) {
            return Either.right((Object)finalFailureReason);
        }
        ((PlayerSyncEvents.StartSyncing)PlayerSyncEvents.START_SYNCING.invoker()).onStartSyncing(this, state);
        ShellState storedState = null;
        if (currentShellContainer != null) {
            storedState = ShellState.of(player, currentPos, currentShellContainer.getColor());
            currentShellContainer.setShellState(storedState);
            if (currentShellContainer.isRemotelyAccessible()) {
                this.add(storedState);
            }
        }
        targetShellContainer.setShellState(null);
        this.remove(state);
        this.apply(state);
        ((PlayerSyncEvents.StopSyncing)PlayerSyncEvents.STOP_SYNCING.invoker()).onStopSyncing((Player)player, currentPos, storedState);
        return Either.left((Object)storedState);
    }

    @Override
    public void apply(ShellState state) {
        Objects.requireNonNull(state);
        ServerPlayer serverPlayer = (ServerPlayer)this;
        MinecraftServer server = Objects.requireNonNull(this.m_284548_().m_7654_());
        ServerLevel targetWorld = WorldUtil.findWorld(server.m_129785_(), state.getWorld()).orElse(null);
        if (targetWorld == null) {
            return;
        }
        this.m_8127_();
        this.m_36328_();
        this.m_20095_();
        this.m_146917_(0);
        this.m_146868_(false);
        this.m_21219_();
        new PlayerIsAlivePacket((Player)serverPlayer).sendToAll(server);
        this.teleport(targetWorld, state.getPos());
        this.isArtificial = state.isArtificial();
        Inventory inventory = this.m_150109_();
        int selectedSlot = inventory.f_35977_;
        state.getInventory().copyTo((Container)inventory);
        inventory.f_35977_ = selectedSlot;
        ShellStateComponent playerComponent = ShellStateComponent.of(serverPlayer);
        playerComponent.clone(state.getComponent());
        serverPlayer.m_143403_(GameType.m_46393_((int)state.getGameMode()));
        this.m_21153_(state.getHealth());
        this.f_36078_ = state.getExperienceLevel();
        this.f_36080_ = state.getExperienceProgress();
        this.f_36079_ = state.getTotalExperience();
        this.m_36324_().m_38705_(state.getFoodLevel());
        this.m_36324_().m_38717_(state.getSaturationLevel());
        this.m_36324_().m_150378_(state.getExhaustion());
        this.undead = false;
        this.f_20890_ = false;
        this.f_20919_ = 0;
        this.f_19789_ = 0.0f;
        this.f_8920_ = -1;
        this.f_8917_ = -1.0f;
        this.f_8918_ = -1;
        this.shellDirty = true;
    }

    @Override
    public Stream<ShellState> getAvailableShellStates() {
        return this.shellsById.values().stream();
    }

    @Override
    public void setAvailableShellStates(Stream<ShellState> states) {
        this.shellsById = states.collect(Collectors.toConcurrentMap(ShellState::getUuid, x -> x));
        this.shellDirty = true;
    }

    @Override
    public ShellState getShellStateByUuid(UUID uuid) {
        return uuid == null ? null : (ShellState)this.shellsById.get(uuid);
    }

    @Override
    public void add(ShellState state) {
        if (!this.canBeApplied(state)) {
            return;
        }
        this.shellsById.put(state.getUuid(), state);
        this.shellStateChanges.put(state.getUuid(), (Tuple<ShellStateUpdateType, ShellState>)new Tuple((Object)ShellStateUpdateType.ADD, (Object)state));
    }

    @Override
    public void remove(ShellState state) {
        if (state == null) {
            return;
        }
        if (this.shellsById.remove(state.getUuid()) != null) {
            this.shellStateChanges.put(state.getUuid(), (Tuple<ShellStateUpdateType, ShellState>)new Tuple((Object)ShellStateUpdateType.REMOVE, (Object)state));
        }
    }

    @Override
    public void update(ShellState state) {
        if (state == null) {
            return;
        }
        boolean updated = this.canBeApplied(state) ? this.shellsById.put(state.getUuid(), state) != null : this.shellsById.computeIfPresent(state.getUuid(), (a, b) -> state) != null;
        this.shellStateChanges.put(state.getUuid(), (Tuple<ShellStateUpdateType, ShellState>)new Tuple((Object)(updated ? ShellStateUpdateType.UPDATE : ShellStateUpdateType.ADD), (Object)state));
    }

    @Inject(method={"playerTick"}, at={@At(value="HEAD")})
    private void playerTick(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        if (this.shellDirty) {
            this.shellDirty = false;
            this.shellStateChanges.clear();
            new ShellUpdatePacket(WorldUtil.getId(this.m_9236_()), this.isArtificial, this.shellsById.values()).send(player);
        }
        for (Tuple<ShellStateUpdateType, ShellState> upd : this.shellStateChanges.values()) {
            new ShellStateUpdatePacket((ShellStateUpdateType)((Object)upd.m_14418_()), (ShellState)upd.m_14419_()).send(player);
        }
        this.shellStateChanges.clear();
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDeath(DamageSource source, CallbackInfo ci) {
        if (!this.isArtificial) {
            return;
        }
        ShellState respawnShell = this.shellsById.values().stream().filter(x -> this.canBeApplied((ShellState)x) && x.getProgress() >= 1.0f).findAny().orElse(null);
        if (respawnShell == null) {
            return;
        }
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_)) {
            this.sendDeathMessageInChat();
        } else {
            this.sendEmptyDeathMessageInChat();
        }
        this.m_36328_();
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46126_)) {
            this.m_9215_();
        }
        if (!this.m_5833_()) {
            this.m_6668_(source);
        }
        this.undead = true;
        ci.cancel();
    }

    @Override
    public boolean updateKillableEntityPostDeath() {
        this.f_20919_ = Mth.m_14045_((int)(++this.f_20919_), (int)0, (int)20);
        if (this.isArtificial && this.shellsById.values().stream().anyMatch(x -> this.canBeApplied((ShellState)x) && x.getProgress() >= 1.0f)) {
            return true;
        }
        if (this.undead) {
            this.m_6667_(this.m_9236_().m_269111_().m_269425_());
            this.undead = false;
        }
        if (this.f_20919_ == 20) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        return true;
    }

    @Unique
    private void sendDeathMessageInChat() {
        Component text = this.m_21231_().m_19293_();
        this.f_8906_.m_243119_((Packet)new ClientboundPlayerCombatKillPacket(this.m_19879_(), text), PacketSendListener.m_243073_(() -> {
            String truncatedString = text.m_130668_(256);
            MutableComponent messageWasTooLong = Component.m_237110_((String)"death.attack.message_too_long", (Object[])new Object[]{Component.m_237113_((String)truncatedString).m_130940_(ChatFormatting.YELLOW)});
            MutableComponent magic = Component.m_237110_((String)"death.attack.even_more_magic", (Object[])new Object[]{this.m_5446_()}).m_130938_(arg_0 -> ServerPlayerEntityMixin.lambda$sendDeathMessageInChat$4((Component)messageWasTooLong, arg_0));
            return new ClientboundPlayerCombatKillPacket(this.m_19879_(), (Component)magic);
        }));
        Team abstractTeam = this.m_5647_();
        if (abstractTeam != null && abstractTeam.m_7468_() != Team.Visibility.ALWAYS) {
            if (abstractTeam.m_7468_() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                this.f_8924_.m_6846_().m_215621_((Player)this, text);
            } else if (abstractTeam.m_7468_() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                this.f_8924_.m_6846_().m_215649_((Player)this, text);
            }
        } else {
            this.f_8924_.m_6846_().m_240416_(text, false);
        }
    }

    @Unique
    private void sendEmptyDeathMessageInChat() {
        this.f_8906_.m_9829_((Packet)new ClientboundPlayerCombatKillPacket(this.m_19879_(), (Component)Component.m_237119_()));
    }

    @Shadow
    protected abstract void m_9215_();

    @Shadow
    protected abstract void m_9209_(ServerLevel var1);

    @Shadow
    public abstract ServerLevel m_284548_();

    @Shadow
    public abstract boolean m_8958_();

    @Shadow
    public abstract void m_8959_();

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        ListTag shellList = new ListTag();
        this.shellsById.values().stream().map(x -> x.writeNbt(new CompoundTag())).forEach(arg_0 -> shellList.add(arg_0));
        nbt.m_128379_("IsArtificial", this.isArtificial);
        nbt.m_128365_("Shells", (Tag)shellList);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        this.isArtificial = nbt.m_128471_("IsArtificial");
        this.shellsById = nbt.m_128437_("Shells", 10).stream().map(x -> ShellState.fromNbt((CompoundTag)x)).collect(Collectors.toConcurrentMap(ShellState::getUuid, x -> x));
        Collection<Tuple<ShellStateUpdateType, ShellState>> updates = ((ShellStateManager)this.f_8924_).popPendingUpdates(this.f_19820_);
        for (Tuple<ShellStateUpdateType, ShellState> update : updates) {
            ShellState state = (ShellState)update.m_14419_();
            switch ((ShellStateUpdateType)((Object)update.m_14418_())) {
                case ADD: 
                case UPDATE: {
                    if (!this.f_19820_.equals(state.getOwnerUuid())) break;
                    this.shellsById.put(state.getUuid(), state);
                    break;
                }
                case REMOVE: {
                    this.shellsById.remove(state.getUuid());
                }
            }
        }
        this.shellStateChanges = new HashMap<UUID, Tuple<ShellStateUpdateType, ShellState>>();
        this.shellDirty = true;
    }

    @Inject(method={"copyFrom"}, at={@At(value="HEAD")})
    private void copyFrom(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        Shell shell = (Shell)oldPlayer;
        this.isArtificial = alive && shell.isArtificial();
        this.shellsById = shell.getAvailableShellStates().collect(Collectors.toConcurrentMap(ShellState::getUuid, x -> x));
        this.shellStateChanges = new HashMap<UUID, Tuple<ShellStateUpdateType, ShellState>>();
        this.shellDirty = true;
    }

    @Inject(method={"setServerWorld"}, at={@At(value="HEAD")})
    private void setWorld(ServerLevel world, CallbackInfo ci) {
        if (world != this.m_9236_()) {
            this.shellDirty = true;
        }
    }

    @Unique
    private void teleport(ServerLevel targetWorld, BlockPos pos) {
        this.f_8927_ = true;
        ChunkAccess chunk = targetWorld.m_46865_(pos);
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        float yaw = BlockPosUtil.getHorizontalFacing(pos, (BlockGetter)chunk).map(d -> Float.valueOf(d.m_122424_().m_122435_())).orElse(Float.valueOf(0.0f)).floatValue();
        float pitch = 0.0f;
        if (this.m_9236_() == targetWorld) {
            this.f_8906_.m_9774_(x, y, z, yaw, pitch);
            this.m_8959_();
            return;
        }
        ServerLevel serverWorld = this.m_284548_();
        ServerPlayer serverPlayer = (ServerPlayer)this;
        LevelData worldProperties = targetWorld.m_6106_();
        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundRespawnPacket(targetWorld.m_220362_(), targetWorld.m_46472_(), BiomeManager.m_47877_((long)targetWorld.m_7328_()), serverPlayer.f_8941_.m_9290_(), serverPlayer.f_8941_.m_9293_(), targetWorld.m_46659_(), targetWorld.m_8584_(), 1, this.m_219759_(), 3));
        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundChangeDifficultyPacket(worldProperties.m_5472_(), worldProperties.m_5474_()));
        PlayerList playerManager = Objects.requireNonNull(this.m_9236_().m_7654_()).m_6846_();
        playerManager.m_11289_(serverPlayer);
        serverWorld.m_143261_(serverPlayer, Entity.RemovalReason.CHANGED_DIMENSION);
        this.m_146912_();
        serverPlayer.m_284535_((Level)targetWorld);
        targetWorld.m_8817_(serverPlayer);
        this.f_8906_.m_9774_(x, y, z, yaw, pitch);
        this.m_9209_(targetWorld);
        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(serverPlayer.m_150110_()));
        playerManager.m_11229_(serverPlayer, targetWorld);
        playerManager.m_11292_(serverPlayer);
        for (MobEffectInstance statusEffectInstance : this.m_21220_()) {
            this.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(this.m_19879_(), statusEffectInstance));
        }
        this.m_8959_();
    }

    private static /* synthetic */ Style lambda$sendDeathMessageInChat$4(Component messageWasTooLong, Style style) {
        return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)messageWasTooLong));
    }
}

