/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public final class BlockPosUtil {
    public static Optional<Direction> getHorizontalFacing(BlockPos pos, BlockGetter blockView) {
        BlockState state = blockView.m_8055_(pos);
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            return Optional.of((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
        }
        return Optional.empty();
    }

    public static boolean hasPlayerInside(BlockPos pos, EntityGetter world) {
        double z;
        double y;
        double x = (double)pos.m_123341_() + 0.5;
        return world.m_45924_(x, y = (double)pos.m_123342_() + 0.5, z = (double)pos.m_123343_() + 0.5, 1.0, false) != null;
    }

    public static boolean isEntityInside(Entity entity, BlockPos pos) {
        double dX = Math.abs((double)pos.m_123341_() + 0.5 - entity.m_20185_());
        double dZ = Math.abs((double)pos.m_123343_() + 0.5 - entity.m_20189_());
        double MAX_DELTA = 0.01;
        return dX < 0.01 && dZ < 0.01;
    }

    public static void moveEntity(Entity entity, BlockPos target, Direction facing, boolean inside) {
        Direction targetDirection = facing.m_122424_();
        Vec3 currentPos = entity.m_20182_();
        double targetX = (double)target.m_123341_() + 0.5;
        double targetZ = (double)target.m_123343_() + 0.5;
        if (!inside) {
            targetX += (double)targetDirection.m_122429_();
            targetZ += (double)targetDirection.m_122431_();
        }
        double currentX = currentPos.f_82479_;
        double currentZ = currentPos.f_82481_;
        double MAX_SPEED = 0.33;
        double velocityX = BlockPosUtil.getMinVelocity(targetX - currentX, 0.33);
        double velocityZ = BlockPosUtil.getMinVelocity(targetZ - currentZ, 0.33);
        float yaw = targetDirection.m_122435_();
        entity.m_20334_(velocityX, 0.0, velocityZ);
        entity.m_146926_(0.0f);
        entity.m_146922_(yaw);
        entity.m_5616_(yaw);
        entity.m_5618_(yaw);
        entity.f_19859_ = yaw;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_20884_ = yaw;
            livingEntity.f_20886_ = yaw;
        }
    }

    private static double getMinVelocity(double velocity, double absLimit) {
        return Math.abs(velocity) < absLimit ? velocity : absLimit * Math.signum(velocity);
    }
}

