/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util;

import dev.kir.sync.Sync;
import dev.kir.sync.config.SyncConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;

public final class ItemUtil {
    private static final TagKey<Item> WRENCHES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("c:wrenches"));

    public static boolean isWrench(ItemStack itemStack) {
        ResourceLocation wrenchId;
        if (itemStack.m_204117_(WRENCHES)) {
            return true;
        }
        SyncConfig config = Sync.getConfig();
        ResourceLocation resourceLocation = wrenchId = config.wrench() == null || config.wrench().isBlank() ? null : ResourceLocation.m_135820_((String)Sync.getConfig().wrench());
        if (wrenchId == null) {
            return false;
        }
        Item wrench = (Item)BuiltInRegistries.f_257033_.m_7745_(wrenchId);
        return wrench != Items.f_41852_ && itemStack.m_150930_(wrench);
    }

    public static boolean isWrench(ItemLike item) {
        return ItemUtil.isWrench(new ItemStack(item));
    }

    public static boolean isArmor(ItemStack itemStack) {
        return ItemUtil.isArmor((ItemLike)itemStack.m_41720_());
    }

    public static boolean isArmor(ItemLike item) {
        return DispenserBlock.f_52661_.get(item.m_5456_()) == ArmorItem.f_40376_;
    }

    public static EquipmentSlot getPreferredEquipmentSlot(ItemStack itemStack) {
        return Mob.m_147233_((ItemStack)itemStack);
    }

    public static EquipmentSlot getPreferredEquipmentSlot(ItemLike item) {
        return ItemUtil.getPreferredEquipmentSlot(new ItemStack(item));
    }
}

