/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util.client;

import com.google.common.collect.Queues;
import dev.kir.sync.Sync;
import dev.kir.sync.util.WorldUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

@Environment(value=EnvType.CLIENT)
public final class PlayerUtil {
    private static final ResourceLocation ANY_WORLD = Sync.locate("any_world");
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static final ConcurrentMap<ResourceLocation, ConcurrentLinkedQueue<PlayerUpdate>> UPDATES = new ConcurrentHashMap<ResourceLocation, ConcurrentLinkedQueue<PlayerUpdate>>();

    public static void recordPlayerUpdate(PlayerUpdate playerUpdate) {
        PlayerUtil.recordPlayerUpdate(null, playerUpdate);
    }

    public static void recordPlayerUpdate(ResourceLocation worldId, PlayerUpdate playerUpdate) {
        ResourceLocation resourceLocation = worldId = worldId == null ? ANY_WORLD : worldId;
        if (PlayerUtil.CLIENT.f_91074_ != null && PlayerUtil.existsInTargetWorld((Entity)PlayerUtil.CLIENT.f_91074_, worldId)) {
            playerUpdate.onLoad(PlayerUtil.CLIENT.f_91074_, PlayerUtil.CLIENT.f_91074_.f_108545_, CLIENT);
        } else {
            UPDATES.computeIfAbsent(worldId, id -> Queues.newConcurrentLinkedQueue()).add(playerUpdate);
        }
    }

    private static boolean existsInTargetWorld(Entity entity, ResourceLocation worldId) {
        return worldId == ANY_WORLD || WorldUtil.isOf(worldId, entity.m_9236_());
    }

    private static void executeUpdates(LocalPlayer player, ClientLevel world, ConcurrentLinkedQueue<PlayerUpdate> queue) {
        if (queue == null) {
            return;
        }
        while (!queue.isEmpty()) {
            queue.poll().onLoad(player, world, CLIENT);
        }
    }

    static {
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity == PlayerUtil.CLIENT.f_91074_) {
                PlayerUtil.executeUpdates(PlayerUtil.CLIENT.f_91074_, world, (ConcurrentLinkedQueue)UPDATES.get(WorldUtil.getId((Level)world)));
                PlayerUtil.executeUpdates(PlayerUtil.CLIENT.f_91074_, world, (ConcurrentLinkedQueue)UPDATES.get(ANY_WORLD));
            }
        });
    }

    @FunctionalInterface
    public static interface PlayerUpdate {
        public void onLoad(LocalPlayer var1, ClientLevel var2, Minecraft var3);
    }
}

